/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.server.git.objects.Branch;
import org.eclipse.orion.server.git.objects.Commit;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Log
extends GitObject {
    private Iterable<RevCommit> commits;
    private String pattern;
    private Ref toRefId;
    private Ref fromRefId;

    public Log(URI cloneLocation, Repository db, Iterable<RevCommit> commits, String pattern, Ref toRefId, Ref fromRefId) {
        super(cloneLocation, db);
        this.commits = commits;
        this.pattern = pattern;
        this.toRefId = toRefId;
        this.fromRefId = fromRefId;
    }

    public void setCommits(Iterable<RevCommit> commits) {
        this.commits = commits;
    }

    public JSONObject toJSON(int page, int pageSize) throws JSONException, URISyntaxException, IOException, CoreException {
        String refTargetName;
        if (this.commits == null) {
            throw new IllegalStateException("'commits' is null");
        }
        Map<ObjectId, JSONArray> commitToBranchMap = Log.getCommitToBranchMap(this.db);
        JSONObject result = new JSONObject();
        boolean pageable = page > 0;
        int startIndex = (page - 1) * pageSize;
        int index = 0;
        JSONArray children = new JSONArray();
        for (RevCommit revCommit : this.commits) {
            if (pageable && index < startIndex) {
                ++index;
                continue;
            }
            if (pageable && index >= startIndex + pageSize) break;
            ++index;
            Commit commit = new Commit(this.cloneLocation, this.db, revCommit, this.pattern);
            commit.setCommitToBranchMap(commitToBranchMap);
            children.put((Object)commit.toJSON());
        }
        result.put("Children", (Object)children);
        result.put("RepositoryPath", (Object)(this.pattern == null ? "" : this.pattern));
        result.put("CloneLocation", (Object)this.cloneLocation);
        if (this.toRefId != null && (refTargetName = this.toRefId.getTarget().getName()).startsWith("refs/heads/")) {
            result.put("toRef", (Object)new Branch(this.cloneLocation, this.db, this.toRefId.getTarget()).toJSON());
        }
        if (this.fromRefId != null && (refTargetName = this.fromRefId.getTarget().getName()).startsWith("refs/heads/")) {
            result.put("fromRef", (Object)new Branch(this.cloneLocation, this.db, this.fromRefId.getTarget()).toJSON());
        }
        return result;
    }

    static Map<ObjectId, JSONArray> getCommitToBranchMap(Repository db) throws JSONException {
        HashMap<ObjectId, JSONArray> commitToBranch = new HashMap<ObjectId, JSONArray>();
        Git git = new Git(db);
        List branchRefs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        for (Ref branchRef : branchRefs) {
            ObjectId commitId = branchRef.getLeaf().getObjectId();
            JSONObject branch = new JSONObject();
            branch.put("FullName", (Object)branchRef.getName());
            JSONArray branchesArray = commitToBranch.get(commitId);
            if (branchesArray != null) {
                branchesArray.put((Object)branch);
                continue;
            }
            branchesArray = new JSONArray();
            branchesArray.put((Object)branch);
            commitToBranch.put(commitId, branchesArray);
        }
        return commitToBranch;
    }
}

