/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONException;
import org.json.JSONObject;

public class Tag
extends GitObject {
    public static final String RESOURCE = "tag";
    public static final String TYPE = "Tag";
    private RevTag tag;
    private Ref ref;
    private URI tagLocation;

    public Tag(URI cloneLocation, Repository db, RevTag tag) throws URISyntaxException, CoreException {
        super(cloneLocation, db);
        this.tag = tag;
    }

    public Tag(URI cloneLocation, Repository db, Ref ref) throws URISyntaxException, CoreException {
        super(cloneLocation, db);
        this.ref = ref;
    }

    public JSONObject toJSON() throws JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        result.put("Name", (Object)this.getName());
        result.put("Location", (Object)this.getLocation());
        result.put("Type", (Object)TYPE);
        return result;
    }

    private String getName() {
        if (this.tag != null) {
            return this.tag.getTagName();
        }
        if (this.ref != null) {
            return Repository.shortenRefName((String)this.ref.getName());
        }
        return null;
    }

    private URI getLocation() throws URISyntaxException {
        if (this.tagLocation == null) {
            Path p = new Path(this.cloneLocation.getPath());
            p = p.uptoSegment(1).append(RESOURCE).append(this.getName()).addTrailingSeparator().append(p.removeFirstSegments(2));
            this.tagLocation = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), p.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        }
        return this.tagLocation;
    }
}

