/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.apache.lucene.util.SortedVIntList;

public class ChainedFilter
extends Filter {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int ANDNOT = 2;
    public static final int XOR = 3;
    public static int DEFAULT = 0;
    private Filter[] chain = null;
    private int[] logicArray;
    private int logic = -1;

    public ChainedFilter(Filter[] chain) {
        this.chain = chain;
    }

    public ChainedFilter(Filter[] chain, int[] logicArray) {
        this.chain = chain;
        this.logicArray = logicArray;
    }

    public ChainedFilter(Filter[] chain, int logic) {
        this.chain = chain;
        this.logic = logic;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        int[] index = new int[]{0};
        if (this.logic != -1) {
            return this.getDocIdSet(reader, this.logic, index);
        }
        if (this.logicArray != null) {
            return this.getDocIdSet(reader, this.logicArray, index);
        }
        return this.getDocIdSet(reader, DEFAULT, index);
    }

    private DocIdSetIterator getDISI(Filter filter, IndexReader reader) throws IOException {
        DocIdSet docIdSet = filter.getDocIdSet(reader);
        if (docIdSet == null) {
            return DocIdSet.EMPTY_DOCIDSET.iterator();
        }
        DocIdSetIterator iter = docIdSet.iterator();
        if (iter == null) {
            return DocIdSet.EMPTY_DOCIDSET.iterator();
        }
        return iter;
    }

    private OpenBitSetDISI initialResult(IndexReader reader, int logic, int[] index) throws IOException {
        OpenBitSetDISI result;
        if (logic == 1) {
            result = new OpenBitSetDISI(this.getDISI(this.chain[index[0]], reader), reader.maxDoc());
            index[0] = index[0] + 1;
        } else if (logic == 2) {
            result = new OpenBitSetDISI(this.getDISI(this.chain[index[0]], reader), reader.maxDoc());
            result.flip(0L, (long)reader.maxDoc());
            index[0] = index[0] + 1;
        } else {
            result = new OpenBitSetDISI(reader.maxDoc());
        }
        return result;
    }

    protected DocIdSet finalResult(OpenBitSetDISI result, int maxDocs) {
        return result.cardinality() < (long)(maxDocs / 9) ? new SortedVIntList((OpenBitSet)result) : result;
    }

    private DocIdSet getDocIdSet(IndexReader reader, int logic, int[] index) throws IOException {
        OpenBitSetDISI result = this.initialResult(reader, logic, index);
        while (index[0] < this.chain.length) {
            this.doChain(result, logic, this.chain[index[0]].getDocIdSet(reader));
            index[0] = index[0] + 1;
        }
        return this.finalResult(result, reader.maxDoc());
    }

    private DocIdSet getDocIdSet(IndexReader reader, int[] logic, int[] index) throws IOException {
        if (logic.length != this.chain.length) {
            throw new IllegalArgumentException("Invalid number of elements in logic array");
        }
        OpenBitSetDISI result = this.initialResult(reader, logic[0], index);
        while (index[0] < this.chain.length) {
            this.doChain(result, logic[index[0]], this.chain[index[0]].getDocIdSet(reader));
            index[0] = index[0] + 1;
        }
        return this.finalResult(result, reader.maxDoc());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChainedFilter: [");
        for (int i = 0; i < this.chain.length; ++i) {
            sb.append(this.chain[i]);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void doChain(OpenBitSetDISI result, int logic, DocIdSet dis) throws IOException {
        if (dis instanceof OpenBitSet) {
            switch (logic) {
                case 0: {
                    result.or((OpenBitSet)dis);
                    break;
                }
                case 1: {
                    result.and((OpenBitSet)dis);
                    break;
                }
                case 2: {
                    result.andNot((OpenBitSet)dis);
                    break;
                }
                case 3: {
                    result.xor((OpenBitSet)dis);
                    break;
                }
                default: {
                    this.doChain(result, DEFAULT, dis);
                    break;
                }
            }
        } else {
            DocIdSetIterator disi;
            if (dis == null) {
                disi = DocIdSet.EMPTY_DOCIDSET.iterator();
            } else {
                disi = dis.iterator();
                if (disi == null) {
                    disi = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
            }
            switch (logic) {
                case 0: {
                    result.inPlaceOr(disi);
                    break;
                }
                case 1: {
                    result.inPlaceAnd(disi);
                    break;
                }
                case 2: {
                    result.inPlaceNot(disi);
                    break;
                }
                case 3: {
                    result.inPlaceXor(disi);
                    break;
                }
                default: {
                    this.doChain(result, DEFAULT, dis);
                }
            }
        }
    }
}

