/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.basic;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.authentication.basic.BasicAuthenticationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.useradmin.User;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicAuthenticationServlet
extends OrionServlet {
    private static final long serialVersionUID = -4208832384205633048L;
    private BasicAuthenticationService authService;

    public BasicAuthenticationServlet(BasicAuthenticationService authService) {
        this.authService = authService;
    }

    private JSONObject getUserJson(String uid) throws JSONException {
        User user;
        JSONObject obj;
        block5: {
            obj = new JSONObject();
            obj.put("login", (Object)uid);
            user = BasicAuthenticationService.userAdmin.getUser("uid", uid);
            if (user != null) break block5;
            return null;
        }
        try {
            IOrionUserProfileNode generalUserProfile = this.authService.getUserProfileService().getUserProfileNode(uid, "general");
            obj.put("uid", (Object)uid);
            obj.put("login", (Object)user.getLogin());
            obj.put("Location", (Object)user.getLocation());
            obj.put("Name", (Object)user.getName());
            if (generalUserProfile.get("lastlogintimestamp", null) != null) {
                Long lastLogin = Long.parseLong(generalUserProfile.get("lastlogintimestamp", ""));
                obj.put("lastlogintimestamp", (Object)lastLogin);
            }
        }
        catch (IllegalArgumentException e) {
            LogHelper.log((Throwable)e);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return obj;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        try {
            resp.getWriter().print(this.getUserJson(this.authService.getAuthenticatedUser(req, resp, null)));
        }
        catch (JSONException jSONException) {}
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.authService.authenticateUser(req, resp, null);
    }
}

