/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.RESOLVE;
    private List<Ref> commits = new LinkedList<Ref>();

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    @Override
    public MergeResult call() throws NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException {
        List<String> unmergedPaths;
        Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults;
        Merger merger;
        String mergeMessage;
        RevCommit headCommit;
        RevCommit srcCommit;
        RevWalk revWalk;
        block25: {
            Object dco;
            Map<String, ResolveMerger.MergeFailureReason> failingPaths;
            block24: {
                boolean noProblems;
                Ref ref;
                StringBuilder refLogMessage;
                Ref head;
                block23: {
                    ObjectId headId;
                    block22: {
                        block21: {
                            this.checkCallable();
                            if (this.commits.size() != 1) {
                                throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
                            }
                            revWalk = null;
                            head = this.repo.getRef("HEAD");
                            if (head == null) {
                                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                            }
                            refLogMessage = new StringBuilder("merge ");
                            revWalk = new RevWalk(this.repo);
                            ref = this.commits.get(0);
                            refLogMessage.append(ref.getName());
                            ObjectId objectId = ref.getPeeledObjectId();
                            if (objectId == null) {
                                objectId = ref.getObjectId();
                            }
                            srcCommit = revWalk.lookupCommit(objectId);
                            headId = head.getObjectId();
                            if (headId != null) break block21;
                            revWalk.parseHeaders(srcCommit);
                            DirCacheCheckout dco2 = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                            dco2.setFailOnConflict(true);
                            dco2.checkout();
                            RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                            refUpdate.setNewObjectId(objectId);
                            refUpdate.setExpectedOldObjectId(null);
                            refUpdate.setRefLogMessage("initial pull", false);
                            if (refUpdate.update() != RefUpdate.Result.NEW) {
                                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                            }
                            this.setCallable(false);
                            MergeResult mergeResult = new MergeResult(srcCommit, srcCommit, new ObjectId[]{null, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                            Object var19_18 = null;
                            if (revWalk != null) {
                                revWalk.release();
                            }
                            return mergeResult;
                        }
                        headCommit = revWalk.lookupCommit(headId);
                        if (!revWalk.isMergedInto(srcCommit, headCommit)) break block22;
                        this.setCallable(false);
                        MergeResult refUpdate = new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                        Object var19_19 = null;
                        if (revWalk != null) {
                            revWalk.release();
                        }
                        return refUpdate;
                    }
                    if (!revWalk.isMergedInto(headCommit, srcCommit)) break block23;
                    refLogMessage.append(": " + (Object)((Object)MergeResult.MergeStatus.FAST_FORWARD));
                    DirCacheCheckout dco3 = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), srcCommit.getTree());
                    dco3.setFailOnConflict(true);
                    dco3.checkout();
                    this.updateHead(refLogMessage, srcCommit, headId);
                    this.setCallable(false);
                    MergeResult mergeResult = new MergeResult(srcCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                    Object var19_20 = null;
                    if (revWalk != null) {
                        revWalk.release();
                    }
                    return mergeResult;
                }
                mergeMessage = new MergeMessageFormatter().format(this.commits, head);
                this.repo.writeMergeCommitMsg(mergeMessage);
                this.repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
                merger = this.mergeStrategy.newMerger(this.repo);
                lowLevelResults = null;
                failingPaths = null;
                unmergedPaths = null;
                if (merger instanceof ResolveMerger) {
                    ResolveMerger resolveMerger = (ResolveMerger)merger;
                    resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                    resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    noProblems = merger.merge(headCommit, srcCommit);
                    lowLevelResults = resolveMerger.getMergeResults();
                    failingPaths = resolveMerger.getFailingPaths();
                    unmergedPaths = resolveMerger.getUnmergedPaths();
                } else {
                    noProblems = merger.merge(headCommit, srcCommit);
                }
                refLogMessage.append(": Merge made by ");
                refLogMessage.append(this.mergeStrategy.getName());
                refLogMessage.append('.');
                if (!noProblems) break block24;
                dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                ((DirCacheCheckout)dco).setFailOnConflict(true);
                ((DirCacheCheckout)dco).checkout();
                RevCommit newHead = new Git(this.getRepository()).commit().setReflogComment(refLogMessage.toString()).call();
                MergeResult mergeResult = new MergeResult(newHead.getId(), null, new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.MERGED, this.mergeStrategy, null, null);
                Object var19_21 = null;
                if (revWalk != null) {
                    revWalk.release();
                }
                return mergeResult;
            }
            if (failingPaths == null) break block25;
            this.repo.writeMergeCommitMsg(null);
            this.repo.writeMergeHeads(null);
            dco = new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.FAILED, this.mergeStrategy, lowLevelResults, failingPaths, null);
            Object var19_22 = null;
            if (revWalk != null) {
                revWalk.release();
            }
            return dco;
        }
        try {
            String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths);
            this.repo.writeMergeCommitMsg(mergeMessageWithConflicts);
            MergeResult mergeResult = new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, this.mergeStrategy, lowLevelResults, null);
            Object var19_23 = null;
            if (revWalk != null) {
                revWalk.release();
            }
            return mergeResult;
        }
        catch (IOException e) {
            try {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), e);
            }
            catch (Throwable throwable) {
                block26: {
                    Object var19_24 = null;
                    if (revWalk == null) break block26;
                    revWalk.release();
                }
                throw throwable;
            }
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public MergeCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public MergeCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }
}

