/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.UploadPackLogger;
import org.eclipse.jgit.transport.UploadPackMayNotContinueException;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadPack {
    static final String OPTION_INCLUDE_TAG = "include-tag";
    static final String OPTION_MULTI_ACK = "multi_ack";
    static final String OPTION_MULTI_ACK_DETAILED = "multi_ack_detailed";
    static final String OPTION_THIN_PACK = "thin-pack";
    static final String OPTION_SIDE_BAND = "side-band";
    static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    static final String OPTION_OFS_DELTA = "ofs-delta";
    static final String OPTION_NO_PROGRESS = "no-progress";
    static final String OPTION_NO_DONE = "no-done";
    static final String OPTION_SHALLOW = "shallow";
    private final Repository db;
    private final RevWalk walk;
    private PackConfig packConfig;
    private int timeout;
    private boolean biDirectionalPipe = true;
    private InterruptTimer timer;
    private InputStream rawIn;
    private OutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private Map<String, Ref> refs;
    private RefFilter refFilter;
    private PreUploadHook preUploadHook = PreUploadHook.NULL;
    private final Set<String> options = new HashSet<String>();
    private final Set<ObjectId> wantIds = new HashSet<ObjectId>();
    private final Set<RevObject> wantAll = new HashSet<RevObject>();
    private final Set<RevObject> commonBase = new HashSet<RevObject>();
    private final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
    private final List<ObjectId> unshallowCommits = new ArrayList<ObjectId>();
    private int depth;
    private int oldestTime;
    private Boolean okToGiveUp;
    private boolean sentReady;
    private Set<ObjectId> advertised;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlag SATISFIED;
    private final RevFlagSet SAVE;
    private RequestPolicy requestPolicy = RequestPolicy.ADVERTISED;
    private BasePackFetchConnection.MultiAck multiAck = BasePackFetchConnection.MultiAck.OFF;
    private boolean noDone;
    private PackWriter.Statistics statistics;
    private UploadPackLogger logger;

    public UploadPack(Repository copyFrom) {
        this.db = copyFrom;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.SATISFIED = this.walk.newFlag("SATISFIED");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
        this.SAVE.add(this.COMMON);
        this.SAVE.add(this.SATISFIED);
        this.refFilter = RefFilter.DEFAULT;
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        if (this.refs == null) {
            this.setAdvertisedRefs(this.db.getAllRefs());
        }
        return this.refs;
    }

    public void setAdvertisedRefs(Map<String, Ref> allRefs) {
        this.refs = this.refFilter.filter(allRefs);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
        if (!this.biDirectionalPipe && this.requestPolicy == RequestPolicy.ADVERTISED) {
            this.requestPolicy = RequestPolicy.REACHABLE_COMMIT;
        }
    }

    public RequestPolicy getRequestPolicy() {
        return this.requestPolicy;
    }

    public void setRequestPolicy(RequestPolicy policy) {
        this.requestPolicy = policy != null ? policy : RequestPolicy.ADVERTISED;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public PreUploadHook getPreUploadHook() {
        return this.preUploadHook;
    }

    public void setPreUploadHook(PreUploadHook hook) {
        this.preUploadHook = hook != null ? hook : PreUploadHook.NULL;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setLogger(UploadPackLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        try {
            this.rawIn = input;
            this.rawOut = output;
            if (this.timeout > 0) {
                Thread caller = Thread.currentThread();
                this.timer = new InterruptTimer(caller.getName() + "-Timer");
                TimeoutInputStream i = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream o = new TimeoutOutputStream(this.rawOut, this.timer);
                i.setTimeout(this.timeout * 1000);
                o.setTimeout(this.timeout * 1000);
                this.rawIn = i;
                this.rawOut = o;
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            this.pckOut = new PacketLineOut(this.rawOut);
            this.service();
        }
        finally {
            this.walk.release();
            if (this.timer != null) {
                try {
                    this.timer.terminate();
                }
                finally {
                    this.timer = null;
                }
            }
        }
    }

    public PackWriter.Statistics getPackStatistics() {
        return this.statistics;
    }

    private void service() throws IOException {
        boolean sendPack;
        if (this.biDirectionalPipe) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
        } else if (this.requestPolicy == RequestPolicy.ANY) {
            this.advertised = Collections.emptySet();
        } else {
            this.advertised = new HashSet<ObjectId>();
            for (Ref ref : this.getAdvertisedRefs().values()) {
                if (ref.getObjectId() == null) continue;
                this.advertised.add(ref.getObjectId());
            }
        }
        try {
            this.recvWants();
            if (this.wantIds.isEmpty()) {
                this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, 0);
                this.preUploadHook.onEndNegotiateRound(this, this.wantIds, 0, 0, false);
                return;
            }
            if (this.options.contains(OPTION_MULTI_ACK_DETAILED)) {
                this.multiAck = BasePackFetchConnection.MultiAck.DETAILED;
                this.noDone = this.options.contains(OPTION_NO_DONE);
            } else {
                this.multiAck = this.options.contains(OPTION_MULTI_ACK) ? BasePackFetchConnection.MultiAck.CONTINUE : BasePackFetchConnection.MultiAck.OFF;
            }
            if (this.depth != 0) {
                this.processShallow();
            }
            sendPack = this.negotiate();
        }
        catch (PackProtocolException err) {
            this.reportErrorDuringNegotiate(err.getMessage());
            throw err;
        }
        catch (UploadPackMayNotContinueException err) {
            if (!err.isOutput() && err.getMessage() != null) {
                try {
                    this.pckOut.writeString("ERR " + err.getMessage() + "\n");
                    err.setOutput();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw err;
        }
        catch (IOException err) {
            this.reportErrorDuringNegotiate(JGitText.get().internalServerError);
            throw err;
        }
        catch (RuntimeException err) {
            this.reportErrorDuringNegotiate(JGitText.get().internalServerError);
            throw err;
        }
        catch (Error err) {
            this.reportErrorDuringNegotiate(JGitText.get().internalServerError);
            throw err;
        }
        if (sendPack) {
            this.sendPack();
        }
    }

    private void reportErrorDuringNegotiate(String msg) {
        try {
            this.pckOut.writeString("ERR " + msg + "\n");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void processShallow() throws IOException {
        RevCommit o;
        DepthWalk.RevWalk depthWalk = new DepthWalk.RevWalk(this.walk.getObjectReader(), this.depth);
        for (ObjectId o2 : this.wantIds) {
            try {
                depthWalk.markRoot(depthWalk.parseCommit(o2));
            }
            catch (IncorrectObjectTypeException notCommit) {}
        }
        while ((o = depthWalk.next()) != null) {
            DepthWalk.Commit c = (DepthWalk.Commit)o;
            if (c.getDepth() == this.depth && !this.clientShallowCommits.contains(c)) {
                this.pckOut.writeString("shallow " + o.name());
            }
            if (c.getDepth() >= this.depth || !this.clientShallowCommits.contains(c)) continue;
            this.unshallowCommits.add(c.copy());
            this.pckOut.writeString("unshallow " + c.name());
        }
        this.pckOut.end();
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException, UploadPackMayNotContinueException {
        try {
            this.preUploadHook.onPreAdvertiseRefs(this);
        }
        catch (UploadPackMayNotContinueException fail) {
            if (fail.getMessage() != null) {
                adv.writeOne("ERR " + fail.getMessage());
                fail.setOutput();
            }
            throw fail;
        }
        adv.init(this.db);
        adv.advertiseCapability(OPTION_INCLUDE_TAG);
        adv.advertiseCapability(OPTION_MULTI_ACK_DETAILED);
        adv.advertiseCapability(OPTION_MULTI_ACK);
        adv.advertiseCapability(OPTION_OFS_DELTA);
        adv.advertiseCapability(OPTION_SIDE_BAND);
        adv.advertiseCapability(OPTION_SIDE_BAND_64K);
        adv.advertiseCapability(OPTION_THIN_PACK);
        adv.advertiseCapability(OPTION_NO_PROGRESS);
        adv.advertiseCapability(OPTION_SHALLOW);
        if (!this.biDirectionalPipe) {
            adv.advertiseCapability(OPTION_NO_DONE);
        }
        adv.setDerefTags(true);
        this.advertised = adv.send(this.getAdvertisedRefs());
        adv.end();
    }

    private void recvWants() throws IOException {
        boolean isFirst = true;
        while (true) {
            String line;
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (line == PacketLineIn.END) break;
            if (line.startsWith("deepen ")) {
                this.depth = Integer.parseInt(line.substring(7));
                continue;
            }
            if (line.startsWith("shallow ")) {
                this.clientShallowCommits.add(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst && line.length() > 45) {
                String opt = line.substring(45);
                if (opt.startsWith(" ")) {
                    opt = opt.substring(1);
                }
                for (String c : opt.split(" ")) {
                    this.options.add(c);
                }
                line = line.substring(0, 45);
            }
            this.wantIds.add(ObjectId.fromString(line.substring(5)));
            isFirst = false;
        }
    }

    private boolean negotiate() throws IOException {
        String line;
        this.okToGiveUp = Boolean.FALSE;
        ObjectId last = ObjectId.zeroId();
        ArrayList<ObjectId> peerHas = new ArrayList<ObjectId>(64);
        while (true) {
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (!this.biDirectionalPipe && this.depth > 0) {
                    return false;
                }
                throw eof;
            }
            if (line == PacketLineIn.END) {
                last = this.processHaveLines(peerHas, last);
                if (this.commonBase.isEmpty() || this.multiAck != BasePackFetchConnection.MultiAck.OFF) {
                    this.pckOut.writeString("NAK\n");
                }
                if (this.noDone && this.sentReady) {
                    this.pckOut.writeString("ACK " + last.name() + "\n");
                    return true;
                }
                if (!this.biDirectionalPipe) {
                    return false;
                }
                this.pckOut.flush();
                continue;
            }
            if (!line.startsWith("have ") || line.length() != 45) break;
            peerHas.add(ObjectId.fromString(line.substring(5)));
        }
        if (line.equals("done")) {
            last = this.processHaveLines(peerHas, last);
            if (this.commonBase.isEmpty()) {
                this.pckOut.writeString("NAK\n");
            } else if (this.multiAck != BasePackFetchConnection.MultiAck.OFF) {
                this.pckOut.writeString("ACK " + last.name() + "\n");
            }
            return true;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "have", line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectId processHaveLines(List<ObjectId> peerHas, ObjectId last) throws IOException {
        this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, peerHas.size());
        if (peerHas.isEmpty()) {
            return last;
        }
        List<ObjectId> toParse = peerHas;
        HashSet<ObjectId> peerHasSet = null;
        boolean needMissing = false;
        this.sentReady = false;
        if (this.wantAll.isEmpty() && !this.wantIds.isEmpty()) {
            peerHasSet = new HashSet<ObjectId>(peerHas);
            int cnt = this.wantIds.size() + peerHasSet.size();
            toParse = new ArrayList<ObjectId>(cnt);
            toParse.addAll(this.wantIds);
            toParse.addAll(peerHasSet);
            needMissing = true;
        }
        HashSet<RevObject> notAdvertisedWants = null;
        int haveCnt = 0;
        AsyncRevObjectQueue q = this.walk.parseAny(toParse, needMissing);
        try {
            while (true) {
                RevObject obj;
                try {
                    obj = q.next();
                }
                catch (MissingObjectException notFound) {
                    ObjectId id = notFound.getObjectId();
                    if (!this.wantIds.contains(id)) continue;
                    String msg = MessageFormat.format(JGitText.get().wantNotValid, id.name());
                    throw new PackProtocolException(msg, notFound);
                }
                if (obj == null) {
                    break;
                }
                if (this.wantIds.remove(obj)) {
                    RevObject target;
                    if (!this.advertised.contains(obj) && this.requestPolicy != RequestPolicy.ANY) {
                        if (notAdvertisedWants == null) {
                            notAdvertisedWants = new HashSet<RevObject>();
                        }
                        notAdvertisedWants.add(obj);
                    }
                    if (!obj.has(this.WANT)) {
                        obj.add(this.WANT);
                        this.wantAll.add(obj);
                    }
                    if (!(obj instanceof RevCommit)) {
                        obj.add(this.SATISFIED);
                    }
                    if (obj instanceof RevTag && (target = this.walk.peel(obj)) instanceof RevCommit && !target.has(this.WANT)) {
                        target.add(this.WANT);
                        this.wantAll.add(target);
                    }
                    if (!peerHasSet.contains(obj)) continue;
                }
                last = obj;
                ++haveCnt;
                if (obj instanceof RevCommit) {
                    RevCommit c = (RevCommit)obj;
                    if (this.oldestTime == 0 || c.getCommitTime() < this.oldestTime) {
                        this.oldestTime = c.getCommitTime();
                    }
                }
                if (obj.has(this.PEER_HAS)) continue;
                obj.add(this.PEER_HAS);
                if (obj instanceof RevCommit) {
                    ((RevCommit)obj).carry(this.PEER_HAS);
                }
                this.addCommonBase(obj);
                switch (this.multiAck) {
                    case OFF: {
                        if (this.commonBase.size() != 1) break;
                        this.pckOut.writeString("ACK " + obj.name() + "\n");
                        break;
                    }
                    case CONTINUE: {
                        this.pckOut.writeString("ACK " + obj.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        this.pckOut.writeString("ACK " + obj.name() + " common\n");
                    }
                }
            }
        }
        finally {
            q.release();
        }
        if (notAdvertisedWants != null && !notAdvertisedWants.isEmpty()) {
            switch (this.requestPolicy) {
                default: {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, ((RevObject)notAdvertisedWants.iterator().next()).name()));
                }
                case REACHABLE_COMMIT: {
                    this.checkNotAdvertisedWants((Set<RevObject>)notAdvertisedWants);
                }
                case ANY: 
            }
        }
        int missCnt = peerHas.size() - haveCnt;
        boolean didOkToGiveUp = false;
        if (0 < missCnt) {
            for (int i = peerHas.size() - 1; i >= 0; --i) {
                ObjectId id = peerHas.get(i);
                if (this.walk.lookupOrNull(id) != null) continue;
                didOkToGiveUp = true;
                if (!this.okToGiveUp()) break;
                switch (this.multiAck) {
                    case OFF: {
                        break;
                    }
                    case CONTINUE: {
                        this.pckOut.writeString("ACK " + id.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        this.pckOut.writeString("ACK " + id.name() + " ready\n");
                        this.sentReady = true;
                    }
                }
                break;
            }
        }
        if (this.multiAck == BasePackFetchConnection.MultiAck.DETAILED && !didOkToGiveUp && this.okToGiveUp()) {
            ObjectId id = peerHas.get(peerHas.size() - 1);
            this.sentReady = true;
            this.pckOut.writeString("ACK " + id.name() + " ready\n");
            this.sentReady = true;
        }
        this.preUploadHook.onEndNegotiateRound(this, this.wantAll, haveCnt, missCnt, this.sentReady);
        peerHas.clear();
        return last;
    }

    private void checkNotAdvertisedWants(Set<RevObject> notAdvertisedWants) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        for (RevObject o : notAdvertisedWants) {
            if (!(o instanceof RevCommit)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, notAdvertisedWants.iterator().next().name()));
            }
            this.walk.markStart((RevCommit)o);
        }
        for (ObjectId id : this.advertised) {
            try {
                this.walk.markUninteresting(this.walk.parseCommit(id));
            }
            catch (IncorrectObjectTypeException notCommit) {}
        }
        RevCommit bad = this.walk.next();
        if (bad != null) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, bad.name()));
        }
        this.walk.reset();
    }

    private void addCommonBase(RevObject o) {
        if (!o.has(this.COMMON)) {
            o.add(this.COMMON);
            this.commonBase.add(o);
            this.okToGiveUp = null;
        }
    }

    private boolean okToGiveUp() throws PackProtocolException {
        if (this.okToGiveUp == null) {
            this.okToGiveUp = this.okToGiveUpImp();
        }
        return this.okToGiveUp;
    }

    private boolean okToGiveUpImp() throws PackProtocolException {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            for (RevObject obj : this.wantAll) {
                if (this.wantSatisfied(obj)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new PackProtocolException(JGitText.get().internalRevisionError, e);
        }
    }

    private boolean wantSatisfied(RevObject want) throws IOException {
        RevCommit c;
        if (want.has(this.SATISFIED)) {
            return true;
        }
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart((RevCommit)want);
        if (this.oldestTime != 0) {
            this.walk.setRevFilter(CommitTimeRevFilter.after((long)this.oldestTime * 1000L));
        }
        while ((c = this.walk.next()) != null) {
            if (!c.has(this.PEER_HAS)) continue;
            this.addCommonBase(c);
            want.add(this.SATISFIED);
            return true;
        }
        return false;
    }

    private void sendPack() throws IOException {
        int eof;
        boolean sideband;
        boolean bl = sideband = this.options.contains(OPTION_SIDE_BAND) || this.options.contains(OPTION_SIDE_BAND_64K);
        if (!this.biDirectionalPipe && 0 <= (eof = this.rawIn.read())) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(eof)));
        }
        if (sideband) {
            try {
                this.sendPack(true);
            }
            catch (UploadPackMayNotContinueException noPack) {
                throw noPack;
            }
            catch (IOException err) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err);
                }
                throw err;
            }
            catch (RuntimeException err) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err);
                }
                throw err;
            }
            catch (Error err) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err);
                }
                throw err;
            }
        } else {
            this.sendPack(false);
        }
    }

    private boolean reportInternalServerErrorOverSideband() {
        try {
            SideBandOutputStream err = new SideBandOutputStream(3, 1000, this.rawOut);
            err.write(Constants.encode(JGitText.get().internalServerError));
            err.flush();
            return true;
        }
        catch (Throwable cannotReport) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPack(boolean sideband) throws IOException {
        ProgressMonitor pm = NullProgressMonitor.INSTANCE;
        OutputStream packOut = this.rawOut;
        SideBandOutputStream msgOut = null;
        if (sideband) {
            int bufsz = 1000;
            if (this.options.contains(OPTION_SIDE_BAND_64K)) {
                bufsz = 65520;
            }
            packOut = new SideBandOutputStream(1, bufsz, this.rawOut);
            if (!this.options.contains(OPTION_NO_PROGRESS)) {
                msgOut = new SideBandOutputStream(2, bufsz, this.rawOut);
                pm = new SideBandProgressMonitor(msgOut);
            }
        }
        try {
            if (this.wantAll.isEmpty()) {
                this.preUploadHook.onSendPack(this, this.wantIds, this.commonBase);
            } else {
                this.preUploadHook.onSendPack(this, this.wantAll, this.commonBase);
            }
        }
        catch (UploadPackMayNotContinueException noPack) {
            if (sideband && noPack.getMessage() != null) {
                noPack.setOutput();
                SideBandOutputStream err = new SideBandOutputStream(3, 1000, this.rawOut);
                err.write(Constants.encode(noPack.getMessage()));
                err.flush();
            }
            throw noPack;
        }
        PackConfig cfg = this.packConfig;
        if (cfg == null) {
            cfg = new PackConfig(this.db);
        }
        PackWriter pw = new PackWriter(cfg, this.walk.getObjectReader());
        try {
            pw.setUseCachedPacks(true);
            pw.setReuseDeltaCommits(true);
            pw.setDeltaBaseAsOffset(this.options.contains(OPTION_OFS_DELTA));
            pw.setThin(this.options.contains(OPTION_THIN_PACK));
            pw.setReuseValidatingObjects(false);
            if (this.commonBase.isEmpty() && this.refs != null) {
                HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
                for (Ref ref : this.refs.values()) {
                    if (ref.getPeeledObjectId() != null) {
                        tagTargets.add(ref.getPeeledObjectId());
                        continue;
                    }
                    if (ref.getObjectId() == null || !ref.getName().startsWith("refs/heads/")) continue;
                    tagTargets.add(ref.getObjectId());
                }
                pw.setTagTargets(tagTargets);
            }
            if (this.depth > 0) {
                pw.setShallowPack(this.depth, this.unshallowCommits);
            }
            RevWalk rw = this.walk;
            if (this.wantAll.isEmpty()) {
                pw.preparePack(pm, this.wantIds, this.commonBase);
            } else {
                this.walk.reset();
                ObjectWalk ow = this.walk.toObjectWalkWithSameObjects();
                pw.preparePack(pm, ow, this.wantAll, this.commonBase);
                rw = ow;
            }
            if (this.options.contains(OPTION_INCLUDE_TAG) && this.refs != null) {
                for (Ref ref : this.refs.values()) {
                    ObjectId peeledId;
                    RevObject obj;
                    ObjectId objectId = ref.getObjectId();
                    if (!this.wantAll.isEmpty() ? (obj = rw.lookupOrNull(objectId)) != null && obj.has(this.WANT) : this.wantIds.contains(objectId)) continue;
                    if (!ref.isPeeled()) {
                        ref = this.db.peel(ref);
                    }
                    if ((peeledId = ref.getPeeledObjectId()) == null) continue;
                    objectId = ref.getObjectId();
                    if (!pw.willInclude(peeledId) || pw.willInclude(objectId)) continue;
                    pw.addObject(rw.parseAny(objectId));
                }
            }
            pw.writePack(pm, NullProgressMonitor.INSTANCE, packOut);
            this.statistics = pw.getStatistics();
            if (msgOut != null) {
                String msg = pw.getStatistics().getMessage() + '\n';
                msgOut.write(Constants.encode(msg));
                msgOut.flush();
            }
        }
        finally {
            pw.release();
        }
        if (sideband) {
            this.pckOut.end();
        }
        if (this.logger != null && this.statistics != null) {
            this.logger.onPackStatistics(this.statistics);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestPolicy {
        ADVERTISED,
        REACHABLE_COMMIT,
        ANY;

    }
}

