/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import org.eclipse.core.runtime.IPath;
import org.eclipse.orion.internal.server.core.tasks.TaskStore;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;

public class TaskService
implements ITaskService {
    TaskStore store;

    public TaskService(IPath baseLocation) {
        this.store = new TaskStore(baseLocation.toFile());
    }

    public TaskInfo createTask() {
        TaskInfo task = new TaskInfo(new UniversalUniqueIdentifier().toBase64String());
        this.store.writeTask(task.getTaskId(), task.toJSON().toString());
        return task;
    }

    public TaskInfo getTask(String id) {
        String taskString = this.store.readTask(id);
        if (taskString == null) {
            return null;
        }
        return TaskInfo.fromJSON(taskString);
    }

    public void updateTask(TaskInfo task) {
        this.store.writeTask(task.getTaskId(), task.toJSON().toString());
    }
}

