/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.TrieField;

class TrieTokenizer
extends Tokenizer {
    protected static final DateField dateField = new DateField();
    protected final int precisionStep;
    protected final TrieField.TrieTypes type;
    protected final NumericTokenStream ts;

    static NumericTokenStream getNumericTokenStream(int precisionStep) {
        return new NumericTokenStream(precisionStep);
    }

    public TrieTokenizer(Reader input, TrieField.TrieTypes type, int precisionStep, NumericTokenStream ts) {
        super((AttributeSource)ts);
        this.type = type;
        this.precisionStep = precisionStep;
        this.ts = ts;
        try {
            this.reset(input);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create TrieIndexTokenizer", (Throwable)e);
        }
    }

    public void reset(Reader input) throws IOException {
        try {
            super.reset(input);
            input = this.input;
            char[] buf = new char[32];
            int len = input.read(buf);
            String v = new String(buf, 0, len);
            switch (this.type) {
                case INTEGER: {
                    this.ts.setIntValue(Integer.parseInt(v));
                    break;
                }
                case FLOAT: {
                    this.ts.setFloatValue(Float.parseFloat(v));
                    break;
                }
                case LONG: {
                    this.ts.setLongValue(Long.parseLong(v));
                    break;
                }
                case DOUBLE: {
                    this.ts.setDoubleValue(Double.parseDouble(v));
                    break;
                }
                case DATE: {
                    this.ts.setLongValue(dateField.parseMath(null, v).getTime());
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
                }
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create TrieIndexTokenizer", (Throwable)e);
        }
        this.ts.reset();
    }

    public boolean incrementToken() throws IOException {
        return this.ts.incrementToken();
    }
}

