/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDirectoryHandler
extends ServletResourceHandler<IFileStore> {
    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws ServletException {
        if (GenericDirectoryHandler.getMethod(request) != ServletResourceHandler.Method.GET) {
            return false;
        }
        try {
            response.setContentType("text/html;charset=UTF-8");
            String path = request.getPathInfo();
            IFileStore[] children = dir.childStores(0, null);
            PrintWriter writer = response.getWriter();
            writer.println("<!DOCTYPE HTML>");
            writer.println("<html>");
            writer.println(" <head>");
            writer.println("<title>Index of " + path + "</title>");
            writer.println("</head>");
            writer.println("<body>");
            writer.println("<h1>Index of " + path + "</h1>");
            writer.println("<pre>Name                          Last modified      Size  ");
            writer.println("<hr>");
            IFileStore[] iFileStoreArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IFileInfo childInfo = child.fetchInfo();
                String childName = child.getName();
                if (childInfo.isDirectory()) {
                    childName = String.valueOf(childName) + '/';
                }
                writer.print("<a href=\"" + childName + "\">" + childName + "</a>");
                int i = childName.length();
                while (i < 30) {
                    writer.print(' ');
                    ++i;
                }
                writer.println(String.valueOf(childInfo.getLastModified()) + "      " + childInfo.getLength());
                ++n2;
            }
            writer.println("<hr>");
            writer.println("</pre>");
            writer.println("</body></html>");
        }
        catch (Exception e) {
            throw new ServletException(NLS.bind((String)"Error retrieving directory: {0}", (Object)dir), (Throwable)e);
        }
        return true;
    }
}

