/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.xfer.ClientExport;
import org.eclipse.orion.internal.server.servlets.xfer.ClientImport;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPTransfer;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.servlets.OrionServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferServlet
extends OrionServlet {
    static final String PREFIX_EXPORT = "export";
    static final String PREFIX_IMPORT = "import";
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
        if (path.segmentCount() > 0) {
            if (PREFIX_IMPORT.equals(path.segment(0))) {
                this.doPostImport(req, resp);
                return;
            }
            if (PREFIX_EXPORT.equals(path.segment(0))) {
                this.doPostExport(req, resp);
                return;
            }
        }
        super.doPost(req, resp);
    }

    private void doPostExport(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String optionString = req.getHeader("X-Xfer-Options");
        List<String> options = TransferServlet.getOptions(optionString);
        if (options.contains("sftp")) {
            new SFTPTransfer(req, resp, this.getStatusHandler(), options).doTransfer();
            return;
        }
        super.doPost(req, resp);
    }

    static List<String> getOptions(String optionString) {
        if (optionString == null) {
            optionString = "";
        }
        return Arrays.asList(optionString.split(","));
    }

    protected void doPostImport(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String optionString = req.getHeader("X-Xfer-Options");
        List<String> options = TransferServlet.getOptions(optionString);
        if (options.contains("sftp")) {
            new SFTPTransfer(req, resp, this.getStatusHandler(), options).doTransfer();
            return;
        }
        long length = -1L;
        try {
            String lengthHeader = req.getHeader("X-Xfer-Content-Length");
            if (lengthHeader == null) {
                lengthHeader = req.getHeader("Content-Length");
            }
            length = Long.parseLong(lengthHeader);
        }
        catch (NumberFormatException e) {
            this.handleException(resp, "Transfer request must indicate transfer size", e, 400);
            return;
        }
        boolean unzip = !options.contains("raw");
        String fileName = req.getHeader("Slug");
        if (fileName == null && !unzip) {
            this.handleException(resp, "Transfer request must indicate target filename", null, 400);
            return;
        }
        IPath path = new Path(req.getPathInfo()).removeFirstSegments(1);
        String uuid = new UniversalUniqueIdentifier().toBase64String();
        ClientImport newImport = new ClientImport(uuid, this.getStatusHandler());
        newImport.setPath(path);
        newImport.setLength(length);
        newImport.setFileName(fileName);
        newImport.setOptions(optionString);
        newImport.doPost(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
        if (path.segmentCount() >= 2 && PREFIX_EXPORT.equals(path.segment(0)) && "zip".equals(path.getFileExtension())) {
            ClientExport export = new ClientExport(path.removeFirstSegments(1).removeFileExtension(), this.getStatusHandler());
            export.doExport(req, resp);
            return;
        }
        super.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
        if (path.segmentCount() == 2) {
            String id = path.segment(1);
            ClientImport importOp = new ClientImport(id, this.getStatusHandler());
            importOp.doPut(req, resp);
            return;
        }
        super.doPut(req, resp);
    }
}

