/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class LogJob
extends GitJob {
    private final LogCommand logCommand;
    private final Log log;
    private final int page;
    private final int pageSize;
    private final URI logLocation;

    public LogJob(LogCommand logCommand, Log log, int page, int pageSize, URI logLocation) {
        super("Log");
        this.logCommand = logCommand;
        this.log = log;
        this.page = page;
        this.pageSize = pageSize;
        this.logLocation = logLocation;
        this.task = this.createTask();
    }

    @Override
    protected TaskInfo createTask() {
        TaskInfo info = this.getTaskService().createTask();
        info.setMessage(NLS.bind((String)"Generating git log for {0} ...", (Object)this.logCommand.getRepository()));
        this.getTaskService().updateTask(info);
        return info;
    }

    private IStatus doLog() {
        try {
            Iterable commits = this.logCommand.call();
            this.log.setCommits(commits);
            JSONObject result = this.log.toJSON(this.page, this.pageSize);
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when generating log for ref {0}", (Object)this.logCommand.getRepository());
            return new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IStatus result = this.doLog();
            if (result.isOK()) {
                this.task.setResultLocation(this.logLocation);
                this.task.done(result);
                this.task.setMessage("Generating git log completed.");
            } else {
                this.task.done(result);
            }
            this.updateTask(this.task);
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.cleanUp();
        }
    }
}

