/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.server.core.users.UserUtilities;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Commit
extends GitObject {
    public static final String RESOURCE = "commit";
    public static final String TYPE = "Commit";
    private RevCommit revCommit;
    private String pattern;
    private TreeFilter filter;
    private boolean isRoot = true;
    private Map<ObjectId, JSONArray> commitToBranchMap;

    public Commit(URI cloneLocation, Repository db, RevCommit revCommit, String pattern) {
        super(cloneLocation, db);
        this.revCommit = revCommit;
        this.pattern = pattern;
        if (pattern != null && !pattern.isEmpty()) {
            this.filter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(pattern)), (TreeFilter)TreeFilter.ANY_DIFF);
            this.isRoot = false;
        }
    }

    public void setCommitToBranchMap(Map<ObjectId, JSONArray> map) {
        this.commitToBranchMap = map;
    }

    public Map<ObjectId, JSONArray> getCommitToBranchMap() throws JSONException {
        if (this.commitToBranchMap == null) {
            this.commitToBranchMap = Log.getCommitToBranchMap(this.db);
        }
        return this.commitToBranchMap;
    }

    public ObjectStream toObjectStream() throws IOException {
        TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)this.pattern, (RevTree)this.revCommit.getTree());
        if (w == null) {
            return null;
        }
        ObjectId blobId = w.getObjectId(0);
        return this.db.open((AnyObjectId)blobId, 3).openStream();
    }

    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException {
        JSONObject commit = new JSONObject();
        commit.put("Location", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2));
        commit.put("ContentLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2.setQuery("parts=body")));
        commit.put("DiffLocation", (Object)this.createDiffLocation(this.revCommit.getName(), null, this.pattern, this.isRoot));
        commit.put("Name", (Object)this.revCommit.getName());
        PersonIdent author = this.revCommit.getAuthorIdent();
        commit.put("AuthorName", (Object)author.getName());
        commit.put("AuthorEmail", (Object)author.getEmailAddress());
        String authorImage = UserUtilities.getImageLink((String)author.getEmailAddress());
        if (authorImage != null) {
            commit.put("AuthorImage", (Object)authorImage);
        }
        PersonIdent committer = this.revCommit.getCommitterIdent();
        commit.put("CommitterName", (Object)committer.getName());
        commit.put("CommitterEmail", (Object)committer.getEmailAddress());
        commit.put("Time", (long)this.revCommit.getCommitTime() * 1000L);
        commit.put("Message", (Object)this.revCommit.getFullMessage());
        commit.put("Tags", (Object)this.toJSON(Commit.getTagsForCommit(this.db, this.revCommit)));
        commit.put("Type", (Object)TYPE);
        commit.put("Branches", (Object)this.getCommitToBranchMap().get(this.revCommit.getId()));
        commit.put("Parents", (Object)this.parentsToJSON(this.revCommit.getParents()));
        if (this.revCommit.getParentCount() > 0) {
            JSONArray diffs = new JSONArray();
            TreeWalk tw = new TreeWalk(this.db);
            RevWalk rw = new RevWalk(this.db);
            RevCommit parent = rw.parseCommit((AnyObjectId)this.revCommit.getParent(0));
            tw.reset(new AnyObjectId[]{parent.getTree(), this.revCommit.getTree()});
            tw.setRecursive(true);
            if (this.filter != null) {
                tw.setFilter(this.filter);
            } else {
                tw.setFilter(TreeFilter.ANY_DIFF);
            }
            List l = DiffEntry.scan((TreeWalk)tw);
            for (DiffEntry entr : l) {
                JSONObject diff = new JSONObject();
                diff.put("Type", (Object)"Diff");
                diff.put("NewPath", (Object)entr.getNewPath());
                diff.put("OldPath", (Object)entr.getOldPath());
                diff.put("ChangeType", (Object)entr.getChangeType().toString());
                String path = entr.getChangeType() != DiffEntry.ChangeType.DELETE ? entr.getNewPath() : entr.getOldPath();
                diff.put("DiffLocation", (Object)this.createDiffLocation(this.revCommit.getName(), this.revCommit.getParent(0).getName(), path, this.isRoot));
                diffs.put((Object)diff);
            }
            tw.release();
            commit.put("Diffs", (Object)diffs);
        }
        return commit;
    }

    private JSONArray toJSON(Map<String, Ref> revTags) throws JSONException {
        JSONArray children = new JSONArray();
        for (Map.Entry<String, Ref> revTag : revTags.entrySet()) {
            JSONObject tag = new JSONObject();
            tag.put("Name", (Object)revTag.getKey());
            tag.put("FullName", (Object)revTag.getValue().getName());
            children.put((Object)tag);
        }
        return children;
    }

    private static Map<String, Ref> getTagsForCommit(Repository repo, RevCommit commit) throws MissingObjectException, IOException {
        HashMap<String, Ref> revTags = new HashMap<String, Ref>();
        RevWalk walk = new RevWalk(repo);
        walk.reset();
        for (Map.Entry revTag : repo.getTags().entrySet()) {
            RevCommit tagCommit;
            RevObject obj = walk.parseAny((AnyObjectId)((Ref)revTag.getValue()).getObjectId());
            if (obj instanceof RevCommit) {
                tagCommit = (RevCommit)obj;
            } else {
                if (!(obj instanceof RevTag)) continue;
                tagCommit = walk.parseCommit((AnyObjectId)((RevTag)obj).getObject());
            }
            if (!commit.equals((AnyObjectId)tagCommit) && !walk.isMergedInto(commit, tagCommit)) continue;
            revTags.put((String)revTag.getKey(), (Ref)revTag.getValue());
        }
        return revTags;
    }

    private URI createDiffLocation(String toRefId, String fromRefId, String path, boolean isRoot) throws URISyntaxException {
        String diffPath = "/gitapi/diff/";
        if (fromRefId != null) {
            diffPath = String.valueOf(diffPath) + fromRefId + "..";
        }
        diffPath = String.valueOf(diffPath) + toRefId + "/";
        if (path == null) {
            diffPath = String.valueOf(diffPath) + new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        } else if (isRoot) {
            diffPath = String.valueOf(diffPath) + new Path(this.cloneLocation.getPath()).removeFirstSegments(2).append(path);
        } else {
            Path p = new Path(this.cloneLocation.getPath());
            diffPath = String.valueOf(diffPath) + p.removeLastSegments(p.segmentCount() - 4).removeFirstSegments(2).append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getAuthority(), diffPath, null, null);
    }

    private JSONArray parentsToJSON(RevCommit[] revCommits) throws JSONException {
        JSONArray parents = new JSONArray();
        RevCommit[] revCommitArray = revCommits;
        int n = revCommits.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit revCommit = revCommitArray[n2];
            JSONObject parent = new JSONObject();
            parent.put("Name", (Object)revCommit.getName());
            parents.put((Object)parent);
            ++n2;
        }
        return parents;
    }
}

