/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.Tag;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitTagHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitTagHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitTagHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle 'tag' request for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        if (p.segment(1).equals("file")) {
            String tagName = p.segment(0);
            p = p.removeFirstSegments(1);
            File gitDir = GitUtils.getGitDir((IPath)p);
            FileRepository db = new FileRepository(gitDir);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG);
            Map refList = db.getRefDatabase().getRefs("refs/tags/");
            Ref ref = (Ref)refList.get(tagName);
            if (ref != null) {
                RevWalk revWalk = new RevWalk((Repository)db);
                try {
                    RevTag revTag = revWalk.parseTag((AnyObjectId)ref.getObjectId());
                    Tag tag = new Tag(cloneLocation, (Repository)db, revTag);
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)tag.toJSON());
                    return true;
                }
                finally {
                    revWalk.release();
                }
            }
            String msg = NLS.bind((String)"Tag not found: {0}", (Object)tagName);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        File gitDir = GitUtils.getGitDir((IPath)p);
        FileRepository db = new FileRepository(gitDir);
        URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG_LIST);
        Map refs = db.getRefDatabase().getRefs("refs/tags/");
        JSONObject result = new JSONObject();
        JSONArray children = new JSONArray();
        for (Map.Entry refEntry : refs.entrySet()) {
            Tag tag = new Tag(cloneLocation, (Repository)db, (Ref)refEntry.getValue());
            children.put((Object)tag.toJSON());
        }
        result.put("Children", (Object)children);
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        return true;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException {
        Path p = new Path(path);
        File gitDir = GitUtils.getGitDir((IPath)p);
        FileRepository db = new FileRepository(gitDir);
        Git git = new Git((Repository)db);
        RevWalk walk = new RevWalk((Repository)db);
        try {
            JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
            String tagName = toPut.getString("Name");
            String commitId = toPut.getString("Commit");
            ObjectId objectId = db.resolve(commitId);
            RevCommit revCommit = walk.lookupCommit((AnyObjectId)objectId);
            RevTag revTag = GitTagHandlerV1.tag(git, revCommit, tagName);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG_LIST);
            Tag tag = new Tag(cloneLocation, (Repository)db, revTag);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)tag.toJSON());
            return true;
        }
        catch (IOException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when tagging.", (Throwable)e));
            return bl;
        }
        catch (GitAPIException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when tagging.", (Throwable)e));
            return bl;
        }
        catch (JGitInternalException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when tagging.", (Throwable)e));
            return bl;
        }
        finally {
            walk.dispose();
        }
    }

    static RevTag tag(Git git, RevCommit revCommit, String tagName) throws JGitInternalException, GitAPIException {
        return git.tag().setObjectId((RevObject)revCommit).setName(tagName).call();
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException {
        Path p = new Path(path);
        File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
        FileRepository db = new FileRepository(gitDir);
        Git git = new Git((Repository)db);
        try {
            git.tagDelete().setTags(new String[]{p.segment(0)}).call();
            return true;
        }
        catch (JGitInternalException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when removing a tag.", (Throwable)e));
        }
    }
}

