/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.internal.server.hosting.NotFoundException;
import org.mortbay.servlet.ProxyServlet;
import org.mortbay.util.IO;

public class RemoteURLProxyServlet
extends ProxyServlet {
    private URL url;
    private final boolean failEarlyOn404;

    public RemoteURLProxyServlet(URL url, boolean failEarlyOn404) {
        this._DontProxyHeaders.add("host");
        this.url = url;
        this.failEarlyOn404 = failEarlyOn404;
    }

    protected URL proxyHttpURL(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        return this.url;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
        } else {
            String connectionHdr;
            String uri = request.getRequestURI();
            if (request.getQueryString() != null) {
                uri = String.valueOf(uri) + "?" + request.getQueryString();
            }
            URL url = this.proxyHttpURL(request.getScheme(), request.getServerName(), request.getServerPort(), uri);
            URLConnection connection = url.openConnection();
            connection.setAllowUserInteraction(false);
            HttpURLConnection http = null;
            if (connection instanceof HttpURLConnection) {
                http = (HttpURLConnection)connection;
                http.setRequestMethod(request.getMethod());
                http.setInstanceFollowRedirects(false);
            }
            if ((connectionHdr = request.getHeader("Connection")) != null && ((connectionHdr = connectionHdr.toLowerCase()).equals("keep-alive") || connectionHdr.equals("close"))) {
                connectionHdr = null;
            }
            boolean xForwardedFor = false;
            boolean hasContent = false;
            Enumeration enm = request.getHeaderNames();
            while (enm.hasMoreElements()) {
                String hdr = (String)enm.nextElement();
                String lhdr = hdr.toLowerCase();
                if ("host".equals(lhdr)) {
                    int port = url.getPort();
                    String realHost = port == -1 || port == url.getDefaultPort() ? url.getHost() : String.valueOf(url.getHost()) + ":" + port;
                    connection.addRequestProperty("Host", realHost);
                }
                if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
                if ("content-type".equals(lhdr) && !"GET".equals(request.getMethod())) {
                    hasContent = true;
                }
                Enumeration vals = request.getHeaders(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null) continue;
                    connection.addRequestProperty(hdr, val);
                    xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                }
            }
            connection.setRequestProperty("Via", "1.1 (jetty)");
            if (!xForwardedFor) {
                connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
            }
            Enumeration maxForwardsHeaders = request.getHeaders("Max-Forwards");
            String maxForwardsHeader = null;
            while (maxForwardsHeaders.hasMoreElements()) {
                maxForwardsHeader = (String)maxForwardsHeaders.nextElement();
            }
            int maxForwards = 5;
            try {
                maxForwards = Math.max(0, Integer.parseInt(maxForwardsHeader));
            }
            catch (NumberFormatException numberFormatException) {}
            if (maxForwards-- < 1) {
                response.sendError(502, "Max-Forwards exceeded");
                return;
            }
            connection.addRequestProperty("Max-Forwards", "" + maxForwards);
            String cache_control = request.getHeader("Cache-Control");
            if (cache_control != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
                connection.setUseCaches(false);
            }
            try {
                connection.setDoInput(true);
                ServletInputStream in = request.getInputStream();
                if (hasContent) {
                    connection.setDoOutput(true);
                    IO.copy((InputStream)in, (OutputStream)connection.getOutputStream());
                }
                connection.connect();
            }
            catch (Exception e) {
                this._context.log("proxy", (Throwable)e);
            }
            InputStream proxy_in = null;
            int code = 500;
            if (http != null) {
                proxy_in = http.getErrorStream();
                code = http.getResponseCode();
                if (this.failEarlyOn404 && code == 404) {
                    throw new NotFoundException();
                }
                response.setStatus(code, http.getResponseMessage());
            }
            if (proxy_in == null) {
                try {
                    proxy_in = connection.getInputStream();
                }
                catch (Exception e) {
                    this._context.log("stream", (Throwable)e);
                    proxy_in = http.getErrorStream();
                }
            }
            response.setHeader("Date", null);
            response.setHeader("Server", null);
            int h = 0;
            String hdr = connection.getHeaderFieldKey(h);
            String val = connection.getHeaderField(h);
            while (hdr != null || val != null) {
                String lhdr;
                String string = lhdr = hdr != null ? hdr.toLowerCase() : null;
                if (hdr != null && val != null && !this._DontProxyHeaders.contains(lhdr)) {
                    response.addHeader(hdr, val);
                }
                hdr = connection.getHeaderFieldKey(++h);
                val = connection.getHeaderField(h);
            }
            response.addHeader("Via", "1.1 (jetty)");
            if (proxy_in != null) {
                IO.copy((InputStream)proxy_in, (OutputStream)response.getOutputStream());
            }
        }
    }
}

