/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Path;

public abstract class BaseToCommitConverter {
    public static final BaseToCommitConverter REMOVE_FIRST_2 = new BaseToCommitConverter(){

        @Override
        public URI baseToCommitLocation(URI base, String commit, String path) throws URISyntaxException {
            Path p = new Path(base.getPath());
            p = p.uptoSegment(1).append("commit").append(commit).addTrailingSeparator().append(p.removeFirstSegments(2));
            if (path != null) {
                p = p.append(path);
            }
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), this.getQuery(base.getQuery()), base.getFragment());
        }
    };
    public static final BaseToCommitConverter REMOVE_FIRST_3 = new BaseToCommitConverter(){

        @Override
        public URI baseToCommitLocation(URI base, String commit, String path) throws URISyntaxException {
            Path p = new Path(base.getPath());
            p = p.uptoSegment(1).append("commit").append(commit).addTrailingSeparator().append(p.removeFirstSegments(3));
            if (path != null) {
                p = p.append(path);
            }
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), this.getQuery(base.getQuery()), base.getFragment());
        }
    };
    protected String query;

    public static URI getCommitLocation(URI base, String commit, BaseToCommitConverter converter) throws IOException, URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(base, commit, null, converter);
    }

    public static URI getCommitLocation(URI base, String commit, String path, BaseToCommitConverter converter) throws IOException, URISyntaxException {
        return converter.baseToCommitLocation(base, commit, path);
    }

    protected abstract URI baseToCommitLocation(URI var1, String var2, String var3) throws URISyntaxException;

    public BaseToCommitConverter setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getQuery(String baseQuery) {
        String result = this.query != null ? this.query : baseQuery;
        this.query = null;
        return result;
    }
}

