/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public class IOUtilities {
    public static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtilities.pipe(inputStream, outputStream, false, false);
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream, boolean closeIn, boolean closeOut) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
        }
        finally {
            if (closeIn) {
                IOUtilities.safeClose(inputStream);
            }
            if (closeOut) {
                IOUtilities.safeClose(outputStream);
            }
        }
    }

    public static void pipe(Reader input, Writer output) throws IOException {
        IOUtilities.pipe(input, output, false, false);
    }

    public static void pipe(Reader reader, Writer writer, boolean closeReader, boolean closeWriter) throws IOException {
        try {
            char[] buffer = new char[4096];
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, read);
            }
        }
        finally {
            if (closeReader) {
                IOUtilities.safeClose(reader);
            }
            if (closeWriter) {
                IOUtilities.safeClose(writer);
            }
        }
    }

    public static String getQueryParameter(HttpServletRequest request, String name) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        String[] stringArray = queryString.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramString = stringArray[n2];
            if (paramString.startsWith(name)) {
                String[] nameAndValue = paramString.split("=", 2);
                if (nameAndValue.length == 2) {
                    return nameAndValue[1];
                }
                return "";
            }
            ++n2;
        }
        return null;
    }

    public static void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String toString(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        IOUtilities.pipe(new InputStreamReader(is, "UTF-8"), writer, true, false);
        return writer.toString();
    }
}

