/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.processor.UpdateRequestProcessor;

class RunUpdateProcessor
extends UpdateRequestProcessor {
    private final SolrQueryRequest req;
    private final UpdateHandler updateHandler;

    public RunUpdateProcessor(SolrQueryRequest req, UpdateRequestProcessor next) {
        super(next);
        this.req = req;
        this.updateHandler = req.getCore().getUpdateHandler();
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        cmd.doc = DocumentBuilder.toDocument(cmd.getSolrInputDocument(), this.req.getSchema());
        this.updateHandler.addDoc(cmd);
        super.processAdd(cmd);
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (cmd.id != null) {
            this.updateHandler.delete(cmd);
        } else {
            this.updateHandler.deleteByQuery(cmd);
        }
        super.processDelete(cmd);
    }

    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        this.updateHandler.mergeIndexes(cmd);
        super.processMergeIndexes(cmd);
    }

    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        this.updateHandler.commit(cmd);
        super.processCommit(cmd);
    }

    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        this.updateHandler.rollback(cmd);
        super.processRollback(cmd);
    }
}

