/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectChecker {
    public static final byte[] tree = Constants.encodeASCII("tree ");
    public static final byte[] parent = Constants.encodeASCII("parent ");
    public static final byte[] author = Constants.encodeASCII("author ");
    public static final byte[] committer = Constants.encodeASCII("committer ");
    public static final byte[] encoding = Constants.encodeASCII("encoding ");
    public static final byte[] object = Constants.encodeASCII("object ");
    public static final byte[] type = Constants.encodeASCII("type ");
    public static final byte[] tag = Constants.encodeASCII("tag ");
    public static final byte[] tagger = Constants.encodeASCII("tagger ");
    private final MutableObjectId tempId = new MutableObjectId();
    private final MutableInteger ptrout = new MutableInteger();

    public void check(int objType, byte[] raw) throws CorruptObjectException {
        switch (objType) {
            case 1: {
                this.checkCommit(raw);
                break;
            }
            case 4: {
                this.checkTag(raw);
                break;
            }
            case 2: {
                this.checkTree(raw);
                break;
            }
            case 3: {
                this.checkBlob(raw);
                break;
            }
            default: {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidType2, objType));
            }
        }
    }

    private int id(byte[] raw, int ptr) {
        try {
            this.tempId.fromString(raw, ptr);
            return ptr + 40;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private int personIdent(byte[] raw, int ptr) {
        int emailB = RawParseUtils.nextLF(raw, ptr, '<');
        if (emailB == ptr || raw[emailB - 1] != 60) {
            return -1;
        }
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailE == emailB || raw[emailE - 1] != 62) {
            return -1;
        }
        if (emailE == raw.length || raw[emailE] != 32) {
            return -1;
        }
        RawParseUtils.parseBase10(raw, emailE + 1, this.ptrout);
        ptr = this.ptrout.value;
        if (emailE + 1 == ptr) {
            return -1;
        }
        if (ptr == raw.length || raw[ptr] != 32) {
            return -1;
        }
        RawParseUtils.parseBase10(raw, ptr + 1, this.ptrout);
        if (ptr + 1 == this.ptrout.value) {
            return -1;
        }
        return this.ptrout.value;
    }

    public void checkCommit(byte[] raw) throws CorruptObjectException {
        int ptr = 0;
        if ((ptr = RawParseUtils.match(raw, ptr, tree)) < 0) {
            throw new CorruptObjectException("no tree header");
        }
        if ((ptr = this.id(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid tree");
        }
        while (RawParseUtils.match(raw, ptr, parent) >= 0) {
            ptr += parent.length;
            if ((ptr = this.id(raw, ptr)) >= 0 && raw[ptr++] == 10) continue;
            throw new CorruptObjectException("invalid parent");
        }
        if ((ptr = RawParseUtils.match(raw, ptr, author)) < 0) {
            throw new CorruptObjectException("no author");
        }
        if ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid author");
        }
        if ((ptr = RawParseUtils.match(raw, ptr, committer)) < 0) {
            throw new CorruptObjectException("no committer");
        }
        if ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid committer");
        }
    }

    public void checkTag(byte[] raw) throws CorruptObjectException {
        int ptr = 0;
        if ((ptr = RawParseUtils.match(raw, ptr, object)) < 0) {
            throw new CorruptObjectException("no object header");
        }
        if ((ptr = this.id(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid object");
        }
        if ((ptr = RawParseUtils.match(raw, ptr, type)) < 0) {
            throw new CorruptObjectException("no type header");
        }
        ptr = RawParseUtils.nextLF(raw, ptr);
        if ((ptr = RawParseUtils.match(raw, ptr, tag)) < 0) {
            throw new CorruptObjectException("no tag header");
        }
        ptr = RawParseUtils.nextLF(raw, ptr);
        if ((ptr = RawParseUtils.match(raw, ptr, tagger)) > 0 && ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10)) {
            throw new CorruptObjectException("invalid tagger");
        }
    }

    private static int lastPathChar(int mode) {
        return FileMode.TREE.equals(mode) ? 47 : 0;
    }

    private static int pathCompare(byte[] raw, int aPos, int aEnd, int aMode, int bPos, int bEnd, int bMode) {
        while (aPos < aEnd && bPos < bEnd) {
            int cmp;
            if ((cmp = (raw[aPos++] & 0xFF) - (raw[bPos++] & 0xFF)) == 0) continue;
            return cmp;
        }
        if (aPos < aEnd) {
            return (raw[aPos] & 0xFF) - ObjectChecker.lastPathChar(bMode);
        }
        if (bPos < bEnd) {
            return ObjectChecker.lastPathChar(aMode) - (raw[bPos] & 0xFF);
        }
        return 0;
    }

    private static boolean duplicateName(byte[] raw, int thisNamePos, int thisNameEnd) {
        int sz = raw.length;
        int nextPtr = thisNameEnd + 1 + 20;
        while (true) {
            byte c;
            int nextMode = 0;
            while (true) {
                byte c2;
                if (nextPtr >= sz) {
                    return false;
                }
                if (32 == (c2 = raw[nextPtr++])) break;
                nextMode <<= 3;
                nextMode += c2 - 48;
            }
            int nextNamePos = nextPtr;
            do {
                if (nextPtr != sz) continue;
                return false;
            } while ((c = raw[nextPtr++]) != 0);
            if (nextNamePos + 1 == nextPtr) {
                return false;
            }
            int cmp = ObjectChecker.pathCompare(raw, thisNamePos, thisNameEnd, FileMode.TREE.getBits(), nextNamePos, nextPtr - 1, nextMode);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0) {
                return true;
            }
            nextPtr += 20;
        }
    }

    public void checkTree(byte[] raw) throws CorruptObjectException {
        int sz = raw.length;
        int ptr = 0;
        int lastNameB = 0;
        int lastNameE = 0;
        int lastMode = 0;
        while (ptr < sz) {
            int cmp;
            int thisNameB;
            int thisMode;
            block14: {
                byte c;
                thisMode = 0;
                while (true) {
                    byte c2;
                    if (ptr == sz) {
                        throw new CorruptObjectException("truncated in mode");
                    }
                    if (32 == (c2 = raw[ptr++])) break;
                    if (c2 < 48 || c2 > 55) {
                        throw new CorruptObjectException("invalid mode character");
                    }
                    if (thisMode == 0 && c2 == 48) {
                        throw new CorruptObjectException("mode starts with '0'");
                    }
                    thisMode <<= 3;
                    thisMode += c2 - 48;
                }
                if (FileMode.fromBits(thisMode).getObjectType() == -1) {
                    throw new CorruptObjectException("invalid mode " + thisMode);
                }
                thisNameB = ptr;
                do {
                    if (ptr == sz) {
                        throw new CorruptObjectException("truncated in name");
                    }
                    if ((c = raw[ptr++]) == 0) break block14;
                } while (c != 47);
                throw new CorruptObjectException("name contains '/'");
            }
            if (thisNameB + 1 == ptr) {
                throw new CorruptObjectException("zero length name");
            }
            if (raw[thisNameB] == 46) {
                int nameLen = ptr - 1 - thisNameB;
                if (nameLen == 1) {
                    throw new CorruptObjectException("invalid name '.'");
                }
                if (nameLen == 2 && raw[thisNameB + 1] == 46) {
                    throw new CorruptObjectException("invalid name '..'");
                }
            }
            if (ObjectChecker.duplicateName(raw, thisNameB, ptr - 1)) {
                throw new CorruptObjectException("duplicate entry names");
            }
            if (lastNameB != 0 && (cmp = ObjectChecker.pathCompare(raw, lastNameB, lastNameE, lastMode, thisNameB, ptr - 1, thisMode)) > 0) {
                throw new CorruptObjectException("incorrectly sorted");
            }
            lastNameB = thisNameB;
            lastNameE = ptr - 1;
            lastMode = thisMode;
            if ((ptr += 20) <= sz) continue;
            throw new CorruptObjectException("truncated in object id");
        }
    }

    public void checkBlob(byte[] raw) throws CorruptObjectException {
    }
}

