/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDiffFilter
extends TreeFilter {
    private final int dirCache;
    private final int workingTree;
    private final boolean honorIgnores;
    private final Set<String> ignoredPaths = new HashSet<String>();

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex) {
        this(dirCacheIndex, workingTreeIndex, true);
    }

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex, boolean honorIgnores) {
        this.dirCache = dirCacheIndex;
        this.workingTree = workingTreeIndex;
        this.honorIgnores = honorIgnores;
    }

    @Override
    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int wm = tw.getRawMode(this.workingTree);
        if (wm == 0) {
            return true;
        }
        int cnt = tw.getTreeCount();
        int dm = tw.getRawMode(this.dirCache);
        WorkingTreeIterator wi = this.workingTree(tw);
        if (dm == 0) {
            if (this.honorIgnores && wi.isEntryIgnored()) {
                int i;
                this.ignoredPaths.add(wi.getEntryPathString());
                for (i = 0; i < cnt && (i == this.dirCache || i == this.workingTree || tw.getRawMode(i) == 0); ++i) {
                }
                return i != cnt;
            }
            return true;
        }
        if (tw.isSubtree()) {
            return true;
        }
        for (int i = 0; i < cnt; ++i) {
            if (i == this.dirCache || i == this.workingTree || tw.getRawMode(i) == dm && tw.idEqual(i, this.dirCache)) continue;
            return true;
        }
        DirCacheIterator di = tw.getTree(this.dirCache, DirCacheIterator.class);
        return wi.isModified(di.getDirCacheEntry(), true);
    }

    private WorkingTreeIterator workingTree(TreeWalk tw) {
        return tw.getTree(this.workingTree, WorkingTreeIterator.class);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "INDEX_DIFF_FILTER";
    }

    public Set<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }
}

