/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.openid.core.Activator;
import org.eclipse.orion.server.openid.core.BundleEntryHttpContext;
import org.eclipse.orion.server.openid.core.OpenIdException;
import org.eclipse.orion.server.openid.core.OpendIdProviderDescription;
import org.eclipse.orion.server.openid.core.OpenidConsumer;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.discovery.Identifier;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIdHelper {
    public static final String OPENID = "openid";
    public static final String OP_RETURN = "op_return";
    public static final String REDIRECT = "redirect";
    static final String OPENID_IDENTIFIER = "openid_identifier";
    static final String OPENID_DISC = "openid-disc";
    private static IOrionCredentialsService userAdmin;
    private static List<OpendIdProviderDescription> defaultOpenids;
    private static IOrionUserProfileService userProfileService;
    private HttpService httpService;
    private static boolean allowAnonymousAccountCreation;

    static {
        allowAnonymousAccountCreation = PreferenceHelper.getString((String)"orion.auth.user.creation", null) == null;
    }

    public static String getAuthenticatedUser(HttpServletRequest req) throws IOException {
        HttpSession s = req.getSession(true);
        if (s.getAttribute("user") != null) {
            return (String)s.getAttribute("user");
        }
        return null;
    }

    public static OpenidConsumer redirectToOpenIdProvider(HttpServletRequest req, HttpServletResponse resp, OpenidConsumer consumer) throws IOException, OpenIdException {
        String redirect = req.getParameter(REDIRECT);
        try {
            StringBuffer sb = OpenIdHelper.getRequestServer(req);
            sb.append(String.valueOf(req.getServletPath()) + (req.getPathInfo() == null ? "" : req.getPathInfo()));
            sb.append("?").append(OP_RETURN).append("=true");
            if (redirect != null && redirect.length() > 0) {
                sb.append("&").append(REDIRECT).append("=");
                sb.append(redirect);
            }
            consumer = new OpenidConsumer(sb.toString());
            consumer.authRequest(req.getParameter(OPENID), req, resp);
        }
        catch (ConsumerException e) {
            throw new OpenIdException(e);
        }
        catch (CoreException e) {
            throw new OpenIdException(e);
        }
        return consumer;
    }

    private static boolean canAddUsers() {
        return allowAnonymousAccountCreation ? userAdmin.canCreateUsers() : false;
    }

    public static void handleOpenIdReturnAndLogin(HttpServletRequest req, HttpServletResponse resp, OpenidConsumer consumer) throws IOException, OpenIdException {
        String redirect = req.getParameter(REDIRECT);
        String op_return = req.getParameter(OP_RETURN);
        if (Boolean.parseBoolean(op_return) && consumer != null) {
            User user;
            Identifier id = consumer.verifyResponse(req);
            if (id == null || id.getIdentifier() == null || id.getIdentifier().equals("")) {
                throw new OpenIdException("Authentication response is not sufficient");
            }
            Set users = userAdmin.getUsersByProperty(OPENID, ".*\\Q" + id.getIdentifier() + "\\E.*", true);
            if (users.size() > 0) {
                user = (User)users.iterator().next();
            } else if (OpenIdHelper.canAddUsers()) {
                User newUser = new User();
                newUser.setName(id.getIdentifier());
                newUser.addProperty(OPENID, id.getIdentifier());
                user = userAdmin.createUser(newUser);
            } else {
                throw new OpenIdException("Your authentication was successful but you are not authorized to access Orion. Contact administrator to create an Orion account.");
            }
            req.getSession().setAttribute("user", (Object)user.getUid());
            IOrionUserProfileNode userProfileNode = OpenIdHelper.getUserProfileService().getUserProfileNode(user.getUid(), "general");
            try {
                userProfileNode.put("lastlogintimestamp", new Long(System.currentTimeMillis()).toString(), false);
                userProfileNode.flush();
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            if (redirect != null) {
                resp.sendRedirect(redirect);
                return;
            }
            return;
        }
    }

    public static void handleOpenIdReturn(HttpServletRequest req, HttpServletResponse resp, OpenidConsumer consumer) throws IOException, OpenIdException {
        String op_return = req.getParameter(OP_RETURN);
        if (Boolean.parseBoolean(op_return) && consumer != null) {
            Identifier id = consumer.verifyResponse(req);
            if (id == null || id.getIdentifier() == null || id.getIdentifier().equals("")) {
                throw new OpenIdException("Authentication response is not sufficient");
            }
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/html; charset=UTF-8");
            out.println("<html><head></head>");
            out.println("<body onload=\"window.opener.handleOpenIDResponse('" + id.getIdentifier() + "');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
    }

    private static StringBuffer getRequestServer(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url;
    }

    public static void performLogout(HttpServletRequest req) {
        HttpSession s = req.getSession(true);
        if (s.getAttribute("user") != null) {
            s.removeAttribute("user");
        }
    }

    public static void writeLoginResponse(String login, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        try {
            JSONObject array = new JSONObject();
            array.put("login", (Object)login);
            resp.getWriter().print(array.toString());
        }
        catch (JSONException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", "An error occured when creating JSON object for logged in user", (Throwable)e));
        }
    }

    public static String getAuthType() {
        return "OpenId";
    }

    public static IOrionCredentialsService getDefaultUserAdmin() {
        return userAdmin;
    }

    public void setUserAdmin(IOrionCredentialsService userAdmin) {
        OpenIdHelper.userAdmin = userAdmin;
    }

    public void unsetUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin.equals(OpenIdHelper.userAdmin)) {
            OpenIdHelper.userAdmin = null;
        }
    }

    public static IOrionUserProfileService getUserProfileService() {
        return userProfileService;
    }

    public static void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        userProfileService = _userProfileService;
    }

    public static void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }

    public void setHttpService(HttpService hs) {
        this.httpService = hs;
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getBundleContext().getBundle());
        try {
            this.httpService.registerResources("/openids", "/openids", (HttpContext)httpContext);
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService hs) {
        if (this.httpService != null) {
            this.httpService.unregister("/openids");
            this.httpService = null;
        }
    }

    private static String getFileContents(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStream is = Activator.getBundleContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private static OpendIdProviderDescription getOpenidProviderFromJson(JSONObject json) throws JSONException {
        OpendIdProviderDescription provider = new OpendIdProviderDescription();
        String url = json.getString("url");
        provider.setAuthSite(url);
        try {
            String name = json.getString("name");
            provider.setName(name);
        }
        catch (JSONException jSONException) {}
        try {
            String image = json.getString("image");
            provider.setImage(image);
        }
        catch (JSONException jSONException) {}
        return provider;
    }

    public static List<OpendIdProviderDescription> getSupportedOpenIdProviders(String openids) throws JSONException {
        ArrayList<OpendIdProviderDescription> opendIdProviders = new ArrayList<OpendIdProviderDescription>();
        JSONArray openidArray = new JSONArray(openids);
        int i = 0;
        while (i < openidArray.length()) {
            JSONObject jsonProvider = openidArray.getJSONObject(i);
            try {
                opendIdProviders.add(OpenIdHelper.getOpenidProviderFromJson(jsonProvider));
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", "Cannot load OpenId provider, invalid entry " + jsonProvider + " Attribute \"ulr\" is mandatory", (Throwable)e));
            }
            ++i;
        }
        return opendIdProviders;
    }

    public static List<OpendIdProviderDescription> getDefaultOpenIdProviders() {
        try {
            if (defaultOpenids == null) {
                defaultOpenids = OpenIdHelper.getSupportedOpenIdProviders(OpenIdHelper.getFileContents("/openids/DefaultOpenIdProviders.json"));
            }
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", "Cannot load default openid list, JSON format expected", (Throwable)e));
            return new ArrayList<OpendIdProviderDescription>();
        }
        return defaultOpenids;
    }
}

