/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Remote;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Branch
extends GitObject {
    public static final String RESOURCE = "branch";
    public static final String TYPE = "Branch";
    private Ref ref;

    public Branch(URI cloneLocation, Repository db, Ref ref) {
        super(cloneLocation, db);
        this.ref = ref;
    }

    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = new JSONObject();
        String shortName = Repository.shortenRefName((String)this.ref.getName());
        result.put("Name", (Object)shortName);
        result.put("Type", (Object)TYPE);
        Path basePath = new Path(this.cloneLocation.getPath());
        IPath newPath = new Path("/gitapi").append(RESOURCE).append(shortName).append(basePath.removeFirstSegments(2));
        URI location = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), newPath.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        result.put("Location", (Object)location);
        result.put("CloneLocation", (Object)this.cloneLocation);
        result.put("CommitLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, shortName, BaseToCommitConverter.REMOVE_FIRST_2));
        result.put("RemoteLocation", (Object)this.getRemotes());
        result.put("HeadLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_2));
        result.put("Current", shortName.equals(this.db.getBranch()));
        return result;
    }

    private JSONArray getRemotes() throws URISyntaxException, JSONException, IOException, CoreException {
        String branchName = Repository.shortenRefName((String)this.ref.getName());
        JSONArray result = new JSONArray();
        StoredConfig config = this.db.getConfig();
        String remote = config.getString(RESOURCE, branchName, "remote");
        if (remote != null) {
            RemoteConfig remoteConfig = new RemoteConfig((Config)config, remote);
            if (!remoteConfig.getFetchRefSpecs().isEmpty()) {
                result.put((Object)new Remote(this.cloneLocation, this.db, remote).toJSON(branchName));
            }
        } else {
            List remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)config);
            for (RemoteConfig remoteConfig : remoteConfigs) {
                if (remoteConfig.getFetchRefSpecs().isEmpty()) continue;
                Remote r = new Remote(this.cloneLocation, this.db, remoteConfig.getName());
                if (this.db.resolve("refs/remotes/" + remoteConfig.getName() + "/" + branchName) != null) {
                    return new JSONArray().put((Object)r.toJSON(branchName));
                }
                result.put((Object)r.toJSON(branchName));
            }
        }
        return result;
    }

    public String toString() {
        return "Branch [ref=" + this.ref + "]";
    }
}

