/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.formopenid.Activator;
import org.eclipse.orion.server.authentication.formopenid.httpcontext.BundleEntryHttpContext;
import org.eclipse.orion.server.authentication.formopenid.servlets.FormOpenIdLoginServlet;
import org.eclipse.orion.server.authentication.formopenid.servlets.FormOpenIdLogoutServlet;
import org.eclipse.orion.server.authentication.formopenid.servlets.ManageOpenidsServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class FormOpenIdAuthenticationService
implements IAuthenticationService {
    private HttpService httpService;
    private Properties defaultAuthenticationProperties;
    public static final String OPENIDS_PROPERTY = "openids";
    private boolean registered = false;

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp, properties);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String formUser = FormAuthHelper.getAuthenticatedUser((HttpServletRequest)req);
        if (formUser != null) {
            return formUser;
        }
        return OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req);
    }

    public String getAuthType() {
        return "FORM";
    }

    public void configure(Properties properties) {
        this.defaultAuthenticationProperties = properties;
        try {
            this.httpService.registerResources("/authenticationPlugin.html", "/web/authenticationPlugin.html", (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
        }
        catch (Exception exception) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.authentication.formopenid", "Reconfiguring FormOpenIdAuthenticationService"));
        }
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            resp.sendRedirect(String.valueOf(req.getContextPath()) + "/mixloginstatic/LoginWindow.html?redirect=" + req.getRequestURL());
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            JSONObject result = new JSONObject();
            try {
                result.put("SignInLocation", (Object)"/mixloginstatic/LoginWindow.html");
                result.put("SignInKey", (Object)"FORMOpenIdUser");
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "An error occured during authenitcation", (Throwable)e));
            }
            resp.getWriter().print(result.toString());
        }
    }

    public void setHttpService(HttpService hs) {
        this.httpService = hs;
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getBundleContext().getBundle());
        try {
            this.httpService.registerResources("/mixloginstatic", "/web", (HttpContext)httpContext);
            this.httpService.registerServlet("/mixlogin/manageopenids", (Servlet)new ManageOpenidsServlet(this), null, (HttpContext)httpContext);
            this.httpService.registerServlet("/login", (Servlet)new FormOpenIdLoginServlet(this), null, (HttpContext)httpContext);
            this.httpService.registerServlet("/logout", (Servlet)new FormOpenIdLogoutServlet(), null, (HttpContext)httpContext);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService hs) {
        if (this.httpService != null) {
            this.httpService.unregister("/mixloginstatic");
            this.httpService.unregister("/mixlogin/manageopenids");
            this.httpService.unregister("/login");
            this.httpService.unregister("/logout");
            this.httpService = null;
        }
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
        Activator.getDefault().getResourceDecorator().setDecorate(registered);
    }

    public boolean getRegistered() {
        return this.registered;
    }
}

