/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.GenericFileHandler;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileHandlerV1
extends GenericFileHandler {
    final ServletResourceHandler<IStatus> statusHandler;
    private static final String EOL = "\r\n";

    FileHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    protected void handleGetMetadata(HttpServletRequest request, HttpServletResponse response, Writer responseWriter, IFileStore file) throws IOException, NoSuchAlgorithmException, JSONException, CoreException {
        JSONObject result = ServletFileStoreHandler.toJSON(file, file.fetchInfo(), FileHandlerV1.getURI(request));
        String etag = FileHandlerV1.generateFileETag(file);
        result.put("ETag", (Object)etag);
        response.setHeader("ETag", etag);
        OrionServlet.decorateResponse(request, result);
        responseWriter.append(result.toString());
    }

    private void handleMultiPartGet(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws IOException, CoreException, NoSuchAlgorithmException, JSONException {
        String boundary = this.createBoundaryString();
        response.setHeader("Content-Type", "multipart/related; boundary=\"" + boundary + '\"');
        ServletOutputStream outputStream = response.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream);
        out.write("--" + boundary + EOL);
        out.write("Content-Type: application/json\r\n\r\n");
        this.handleGetMetadata(request, response, out, file);
        out.write("\r\n--" + boundary + EOL);
        out.write(EOL);
        ((Writer)out).flush();
        IOUtilities.pipe((InputStream)file.openInputStream(0, null), (OutputStream)outputStream, (boolean)true, (boolean)false);
        out.write("\r\n--" + boundary + EOL);
        ((Writer)out).flush();
    }

    String createBoundaryString() {
        return new UniversalUniqueIdentifier().toBase64String();
    }

    private void handlePutContents(HttpServletRequest request, BufferedReader requestReader, HttpServletResponse response, IFileStore file) throws IOException, CoreException, NoSuchAlgorithmException, JSONException {
        BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter(file.openOutputStream(0, null)));
        IOUtilities.pipe((Reader)requestReader, (Writer)fileWriter, (boolean)false, (boolean)true);
        this.handleGetMetadata(request, response, response.getWriter(), file);
    }

    private void handleMultiPartPut(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws IOException, CoreException, JSONException, NoSuchAlgorithmException {
        String line;
        String typeHeader = request.getHeader("Content-Type");
        String boundary = typeHeader.substring(typeHeader.indexOf("boundary=\"") + 10, typeHeader.length() - 1);
        BufferedReader requestReader = request.getReader();
        this.handlePutMetadata(requestReader, boundary, file);
        HashMap<String, String> contentHeaders = new HashMap<String, String>();
        while ((line = requestReader.readLine()) != null && line.length() > 0) {
            String[] header = line.split(":");
            if (header.length != 2) continue;
            contentHeaders.put(header[0], header[1]);
        }
        this.handlePutContents(request, requestReader, response, file);
    }

    private void handlePutMetadata(BufferedReader reader, String boundary, IFileStore file) throws IOException, CoreException, JSONException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null && !line.equals(boundary)) {
            buf.append(line);
        }
        FileInfo info = (FileInfo)file.fetchInfo();
        ServletFileStoreHandler.copyJSONToFileInfo(new JSONObject(buf.toString()), info);
        file.putInfo((IFileInfo)info, 1024, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        try {
            String receivedETag = request.getHeader("If-Match");
            if (receivedETag != null && !receivedETag.equals(FileHandlerV1.generateFileETag(file))) {
                response.setStatus(412);
                return true;
            }
            String parts = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"parts");
            if (parts == null || "body".equals(parts)) {
                switch (FileHandlerV1.getMethod(request)) {
                    case DELETE: {
                        file.delete(0, null);
                        return true;
                    }
                    case PUT: {
                        this.handlePutContents(request, request.getReader(), response, file);
                        return true;
                    }
                }
                this.handleFileContents(request, response, file);
                return true;
            }
            if ("meta".equals(parts)) {
                switch (FileHandlerV1.getMethod(request)) {
                    case GET: {
                        this.handleGetMetadata(request, response, response.getWriter(), file);
                        return true;
                    }
                    case PUT: {
                        this.handlePutMetadata(request.getReader(), null, file);
                        response.setStatus(204);
                        return true;
                    }
                }
                return false;
            }
            if (!"meta,body".equals(parts)) {
                if (!"body,meta".equals(parts)) return false;
            }
            switch (FileHandlerV1.getMethod(request)) {
                case GET: {
                    this.handleMultiPartGet(request, response, file);
                    return true;
                }
                case PUT: {
                    this.handleMultiPartPut(request, response, file);
                    return true;
                }
            }
            return false;
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (Exception e) {
            throw new ServletException(NLS.bind((String)"Error retrieving file: {0}", (Object)file), (Throwable)e);
        }
    }
}

