/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Status
extends GitObject {
    public static final String RESOURCE = "status";
    public static final String TYPE = "Status";
    private URI baseLocation;
    private org.eclipse.jgit.api.Status status;
    private IPath basePath;

    public Status(URI baseLocation, Repository db, org.eclipse.jgit.api.Status status, IPath basePath) throws URISyntaxException, CoreException {
        super(BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.STATUS), db);
        this.baseLocation = baseLocation;
        this.status = status;
        this.basePath = basePath;
    }

    public JSONObject toJSON() throws JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        result.put("CloneLocation", (Object)this.cloneLocation);
        JSONArray children = this.toJSONArray(this.status.getAdded(), this.basePath, this.baseLocation, "Default");
        result.put("Added", (Object)children);
        children = this.toJSONArray(this.status.getChanged(), this.basePath, this.baseLocation, "Cached");
        result.put("Changed", (Object)children);
        children = this.toJSONArray(this.status.getMissing(), this.basePath, this.baseLocation, "Default");
        result.put("Missing", (Object)children);
        children = this.toJSONArray(this.status.getModified(), this.basePath, this.baseLocation, "Default");
        result.put("Modified", (Object)children);
        children = this.toJSONArray(this.status.getRemoved(), this.basePath, this.baseLocation, "Cached");
        result.put("Removed", (Object)children);
        children = this.toJSONArray(this.status.getUntracked(), this.basePath, this.baseLocation, "Default");
        result.put("Untracked", (Object)children);
        children = this.toJSONArray(this.status.getConflicting(), this.basePath, this.baseLocation, "Default");
        result.put("Conflicting", (Object)children);
        result.put("RepositoryState", (Object)this.db.getRepositoryState().name());
        result.put("IndexLocation", (Object)this.statusToIndexLocation(this.baseLocation));
        result.put("CommitLocation", (Object)this.statusToCommitLocation(this.baseLocation, "HEAD"));
        result.put("Type", (Object)TYPE);
        return result;
    }

    private JSONArray toJSONArray(Set<String> set, IPath basePath, URI baseLocation, String diffType) throws JSONException, URISyntaxException {
        JSONArray result = new JSONArray();
        for (String s : set) {
            JSONObject object = new JSONObject();
            object.put("Name", (Object)s);
            IPath relative = new Path(s).makeRelativeTo(basePath);
            object.put("Path", (Object)relative);
            URI fileLocation = this.statusToFileLocation(baseLocation);
            object.put("Location", (Object)URIUtil.append((URI)fileLocation, (String)relative.toString()));
            JSONObject gitSection = new JSONObject();
            URI diffLocation = this.statusToDiffLocation(baseLocation, diffType);
            gitSection.put("DiffLocation", (Object)URIUtil.append((URI)diffLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            URI commitLocation = this.statusToCommitLocation(baseLocation, "HEAD");
            gitSection.put("CommitLocation", (Object)URIUtil.append((URI)commitLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            URI indexLocation = this.statusToIndexLocation(baseLocation);
            gitSection.put("IndexLocation", (Object)URIUtil.append((URI)indexLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            result.put((Object)object);
        }
        return result;
    }

    private URI statusToFileLocation(URI u) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToDiffLocation(URI u, String diffType) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        uriPath = String.valueOf(prefix) + "/gitapi" + "/" + "diff" + "/" + diffType + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToCommitLocation(URI u, String ref) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        uriPath = String.valueOf(prefix) + "/gitapi" + "/" + "commit" + "/" + ref + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToIndexLocation(URI u) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        uriPath = String.valueOf(prefix) + "/gitapi" + "/" + "index" + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }
}

