/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTagCommand
extends GitCommand<List<RevTag>> {
    protected ListTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<RevTag> call() throws JGitInternalException {
        this.checkCallable();
        ArrayList<RevTag> tags = new ArrayList<RevTag>();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            try {
                Map<String, Ref> refList = this.repo.getRefDatabase().getRefs("refs/tags/");
                for (Ref ref : refList.values()) {
                    RevTag tag = revWalk.parseTag(ref.getObjectId());
                    tags.add(tag);
                }
                Object var8_8 = null;
                revWalk.release();
            }
            catch (IOException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            revWalk.release();
            throw throwable;
        }
        Collections.sort(tags, new Comparator<RevTag>(){

            @Override
            public int compare(RevTag o1, RevTag o2) {
                return o1.getTagName().compareTo(o2.getTagName());
            }
        });
        this.setCallable(false);
        return tags;
    }
}

