/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator.servlet;

import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.servlet.GzipFilter;

public class ExcludedExtensionGzipFilter
extends GzipFilter {
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    private HashSet<String> excludedExtensions = new HashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String excludedExtensionsParam = filterConfig.getInitParameter("excludedExtensions");
        if (excludedExtensionsParam != null) {
            StringTokenizer tokenizer = new StringTokenizer(excludedExtensionsParam, ",", false);
            while (tokenizer.hasMoreTokens()) {
                this.excludedExtensions.add(tokenizer.nextToken().trim());
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) == null && !this.isExcludedFileExtension(httpRequest.getPathInfo())) {
            super.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isExcludedFileExtension(String pathInfo) {
        String extension;
        if (pathInfo == null || this.excludedExtensions.isEmpty()) {
            return false;
        }
        int dot = pathInfo.lastIndexOf(46);
        return dot != -1 && this.excludedExtensions.contains(extension = pathInfo.substring(dot + 1).toLowerCase());
    }
}

