/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class ElisionFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Set articles;

    public void inform(ResourceLoader loader) {
        String articlesFile = (String)this.args.get("articles");
        if (articlesFile != null) {
            try {
                List wlist = loader.getLines(articlesFile);
                this.articles = StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("No articles specified for ElisionFilterFactory");
        }
    }

    public ElisionFilter create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }
}

