/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterUtils;
import org.eclipse.help.webapp.IFilter;

public class HighlightFilter
implements IFilter {
    private static final String HIGHLIGHT_ON = "highlight-on";
    private static final String scriptPart1 = "\n<script type=\"text/javascript\">\n<!--\nvar keywords = new Array (";
    private static final String scriptPart2 = ");\nvar pluginDefault = ";
    private static final String scriptPart3 = ";\n-->\n</script>\n<script type=\"text/javascript\" src=\"";
    private static final String scriptPart5 = "advanced/highlight.js\"></script>\n";
    private static final String sheetRefPart1 = "<link id=\"highlightStyle\" rel=\"STYLESHEET\" href=\"";
    private static final String sheetRefPart3 = "advanced/highlight.css\" charset=\"ISO-8859-1\" type=\"text/css\"></link>\n";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        String uri = req.getRequestURI();
        if (uri == null) {
            return out;
        }
        if (!UrlUtil.isIE(req) && !UrlUtil.isMozilla(req)) {
            return out;
        }
        Collection keywords = this.getWords(req);
        if (keywords.size() == 0) {
            return out;
        }
        keywords = this.removeWildCards(keywords);
        byte[] script = this.createJScript(req, keywords = this.encodeKeyWords(keywords));
        if (script == null) {
            return out;
        }
        return new FilterHTMLHeadOutputStream(out, script);
    }

    private byte[] createJScript(HttpServletRequest req, Collection keywords) {
        StringBuffer buf = new StringBuffer(scriptPart1);
        StringBuffer buf2 = new StringBuffer(sheetRefPart1);
        Iterator it = keywords.iterator();
        if (!it.hasNext()) {
            return null;
        }
        String keyword = (String)it.next();
        buf.append("\"").append(keyword).append("\"");
        while (it.hasNext()) {
            keyword = (String)it.next();
            buf.append(", \"").append(keyword).append("\"");
        }
        buf.append(scriptPart2);
        buf.append(Platform.getPreferencesService().getBoolean("org.eclipse.help.base", HIGHLIGHT_ON, false, null));
        buf.append(scriptPart3);
        String path = FilterUtils.getRelativePathPrefix(req);
        buf.append(path);
        buf2.append(path);
        buf.append(scriptPart5);
        buf.append(buf2.toString());
        buf.append(sheetRefPart3);
        try {
            return buf.toString().getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    private Collection getWords(HttpServletRequest req) {
        ArrayList<String> tokens = new ArrayList<String>();
        String searchWord = req.getParameter("resultof");
        if (searchWord == null) {
            return tokens;
        }
        StringTokenizer qTokenizer = new StringTokenizer(searchWord.trim(), "\"", true);
        boolean withinQuotation = false;
        String quotedString = "";
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (!withinQuotation) {
                    quotedString = "";
                } else {
                    tokens.add(quotedString);
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (!withinQuotation) continue;
            tokens.add(curToken);
        }
        return tokens;
    }

    private Collection encodeKeyWords(Collection col) {
        if (col == null) {
            return col;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            String word = (String)it.next();
            int l = word.length();
            if (l < 1) continue;
            result.add(UrlUtil.JavaScriptEncode(word));
        }
        return result;
    }

    private Collection removeWildCards(Collection col) {
        if (col == null) {
            return col;
        }
        ArrayList<String> resultPass1 = new ArrayList<String>();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            int index;
            String word = (String)it.next();
            while ((index = word.indexOf("*")) >= 0) {
                if (index > 0) {
                    resultPass1.add(word.substring(0, index));
                }
                if (word.length() <= index) continue;
                word = word.substring(index + 1);
            }
            if (word.length() <= 0) continue;
            resultPass1.add(word);
        }
        ArrayList<String> resultPass2 = new ArrayList<String>();
        Iterator it2 = resultPass1.iterator();
        while (it2.hasNext()) {
            int index;
            String word = (String)it2.next();
            while ((index = word.indexOf("?")) >= 0) {
                if (index > 0) {
                    resultPass2.add(word.substring(0, index));
                }
                if (word.length() <= index) continue;
                word = word.substring(index + 1);
            }
            if (word.length() <= 0) continue;
            resultPass2.add(word);
        }
        return resultPass2;
    }
}

