/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.openid.Activator;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.eclipse.orion.server.openid.httpcontext.BundleEntryHttpContext;
import org.eclipse.orion.server.openid.servlet.OpenIdLogoutServlet;
import org.eclipse.orion.server.openid.servlet.OpenidServlet;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class OpenidAuthenticationService
implements IAuthenticationService {
    private HttpService httpService;
    public static final String OPENIDS_PROPERTY = "openids";
    private boolean registered;

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        return OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req);
    }

    public String getAuthType() {
        return OpenIdHelper.getAuthType();
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            try {
                req.getRequestDispatcher("/openidstatic/LoginWindow.html").forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "An error occured during authenitcation", (Throwable)e));
            }
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            JSONObject result = new JSONObject();
            try {
                result.put("SignInLocation", (Object)"/openidstatic/LoginWindow.html");
                result.put("label", (Object)"Orion workspace server");
                result.put("SignInKey", (Object)"OpenIdSignInKey");
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "An error occured during authenitcation", (Throwable)e));
            }
            resp.getWriter().print(result.toString());
        }
    }

    public void configure(Properties properties) {
        try {
            this.httpService.registerResources("/authenticationPlugin.html", "/web/authenticationPlugin.html", (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
        }
        catch (Exception exception) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.openid", "Reconfiguring FormOpenIdAuthenticationService"));
        }
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp);
        }
        return user;
    }

    public void setHttpService(HttpService httpService) {
        Activator.getDefault();
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getBundleContext().getBundle());
        this.httpService = httpService;
        try {
            httpService.registerServlet("/openid", (Servlet)new OpenidServlet(), null, (HttpContext)httpContext);
            httpService.registerServlet("/logout", (Servlet)new OpenIdLogoutServlet(), null, (HttpContext)httpContext);
            httpService.registerResources("/openidstatic", "/web", (HttpContext)httpContext);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService httpService) {
        httpService.unregister("/openid");
        httpService.unregister("/openidstatic");
        this.httpService = null;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean getRegistered() {
        return this.registered;
    }
}

