/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.DocumentAnalysisResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentAnalysisRequest
extends SolrRequest {
    private List<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
    private String query;
    private boolean showMatch = false;

    public DocumentAnalysisRequest() {
        super(SolrRequest.METHOD.POST, "/analysis/document");
    }

    public DocumentAnalysisRequest(String uri) {
        super(SolrRequest.METHOD.POST, uri);
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "text/xml; charset=utf-8");
    }

    public ModifiableSolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (this.query != null) {
            params.add("analysis.query", new String[]{this.query});
            params.add("analysis.showmatch", new String[]{String.valueOf(this.showMatch)});
        }
        return params;
    }

    @Override
    public DocumentAnalysisResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = System.currentTimeMillis();
        DocumentAnalysisResponse res = new DocumentAnalysisResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }

    String getXML() throws IOException {
        StringWriter writer = new StringWriter();
        writer.write("<docs>");
        for (SolrInputDocument document : this.documents) {
            ClientUtils.writeXML(document, writer);
        }
        writer.write("</docs>");
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    public DocumentAnalysisRequest addDocument(SolrInputDocument doc) {
        this.documents.add(doc);
        return this;
    }

    public DocumentAnalysisRequest addDocuments(Collection<SolrInputDocument> docs) {
        this.documents.addAll(docs);
        return this;
    }

    public DocumentAnalysisRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public DocumentAnalysisRequest setShowMatch(boolean showMatch) {
        this.showMatch = showMatch;
        return this;
    }

    public List<SolrInputDocument> getDocuments() {
        return this.documents;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isShowMatch() {
        return this.showMatch;
    }
}

