/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.core.tasks.TaskStore;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.core.tasks.ITaskCanceler;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskDoesNotExistException;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskModificationListener;
import org.eclipse.orion.server.core.tasks.TaskOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService
implements ITaskService {
    TaskStore store;
    private Map<String, ITaskCanceler> taskCancelers = new HashMap<String, ITaskCanceler>();
    private Set<TaskModificationListener> taskListeners = new HashSet<TaskModificationListener>();
    private Map<String, List<TaskDeletion>> taskDeletions = new HashMap<String, List<TaskDeletion>>();

    public TaskService(IPath baseLocation) {
        this.store = new TaskStore(baseLocation.toFile());
        this.cleanUpTasks();
    }

    private void cleanUpTasks() {
        List<String> allTasks = this.store.readAllTasks();
        Calendar monthAgo = Calendar.getInstance();
        monthAgo.add(2, -1);
        for (String taskString : allTasks) {
            TaskInfo task = TaskInfo.fromJSON(taskString);
            if (task == null) continue;
            if (task.isRunning()) {
                task.done((IStatus)new ServerStatus(4, 500, "Task could not be completed due to server restart", null));
                this.updateTask(task);
            }
            if (!task.getModified().before(monthAgo.getTime())) continue;
            try {
                this.removeTask(task.getUserId(), task.getTaskId());
            }
            catch (TaskOperationException e) {
                LogHelper.log(e);
            }
        }
    }

    @Override
    public TaskInfo createTask(String taskName, String userId, boolean isIdempotent) {
        return this.createTask(taskName, userId, null, isIdempotent);
    }

    private TaskInfo internalRemoveTask(String userId, String id, Date dateRemoved) throws TaskOperationException {
        TaskInfo task = this.getTask(userId, id);
        if (task == null) {
            throw new TaskDoesNotExistException(id);
        }
        if (task.isRunning()) {
            throw new TaskOperationException("Cannot remove a task that is running. Try to cancel first");
        }
        if (!this.store.removeTask(userId, id)) {
            throw new TaskOperationException("Task could not be removed");
        }
        this.taskCancelers.remove(id);
        if (!this.taskDeletions.containsKey(userId)) {
            this.taskDeletions.put(userId, new ArrayList());
        }
        int i = this.taskDeletions.get(userId).size();
        while (i > 0 && this.taskDeletions.get((Object)userId).get((int)(i - 1)).deletionDate.after(dateRemoved)) {
            --i;
        }
        this.taskDeletions.get(userId).add(i, new TaskDeletion(dateRemoved, id));
        return task;
    }

    @Override
    public void removeTask(String userId, String id) throws TaskOperationException {
        Date date = new Date();
        this.internalRemoveTask(userId, id, date);
        this.notifyDeletionListeners(userId, date);
    }

    @Override
    public void removeCompletedTasks(String userId) {
        Date date = new Date();
        for (TaskInfo task : this.getTasks(userId)) {
            if (task.isRunning()) continue;
            try {
                this.internalRemoveTask(userId, task.getTaskId(), date);
            }
            catch (TaskOperationException e) {
                LogHelper.log(e);
            }
        }
        this.notifyDeletionListeners(userId, date);
    }

    @Override
    public TaskInfo createTask(String taskName, String userId, ITaskCanceler taskCanceler, boolean isIdempotent) {
        TaskInfo task = new TaskInfo(userId, new UniversalUniqueIdentifier().toBase64String(), isIdempotent);
        task.setName(taskName);
        if (taskCanceler != null) {
            this.taskCancelers.put(task.getTaskId(), taskCanceler);
            task.setCanBeCanceled(true);
        }
        this.store.writeTask(userId, task.getTaskId(), task.toJSON().toString());
        this.notifyListeners(userId, task.getModified());
        return task;
    }

    private void notifyListeners(String userId, Date modificationDate) {
        new TasksNotificationJob(userId, modificationDate).schedule();
    }

    private void notifyDeletionListeners(String userId, Date deletionDate) {
        new DeletedTasksNotificationJob(userId, deletionDate).schedule();
    }

    @Override
    public TaskInfo getTask(String userId, String id) {
        String taskString = this.store.readTask(userId, id);
        if (taskString == null) {
            return null;
        }
        TaskInfo info = TaskInfo.fromJSON(taskString);
        if (this.taskCancelers.get(id) != null) {
            info.setCanBeCanceled(true);
        }
        return info;
    }

    @Override
    public void updateTask(TaskInfo task) {
        task.setModified(new Date());
        this.store.writeTask(task.getUserId(), task.getTaskId(), task.toJSON().toString());
        this.notifyListeners(task.getUserId(), task.getModified());
    }

    @Override
    public List<TaskInfo> getTasks(String userId) {
        return this.getTasks(userId, null, false);
    }

    @Override
    public void cancelTask(TaskInfo task) throws TaskOperationException {
        ITaskCanceler taskCanceler = this.taskCancelers.get(task.getTaskId());
        if (taskCanceler == null) {
            throw new TaskOperationException("Task does not support canceling.");
        }
        taskCanceler.cancelTask();
    }

    @Override
    public List<TaskInfo> getTasks(String userId, Date modifiedSince, boolean running) {
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        for (String taskString : this.store.readAllTasks(userId)) {
            TaskInfo info = TaskInfo.fromJSON(taskString);
            if (modifiedSince != null && info.getModified().getTime() < modifiedSince.getTime() || running && !info.isRunning()) continue;
            ITaskCanceler taskCanceler = this.taskCancelers.get(info.getTaskId());
            if (taskCanceler != null) {
                info.setCanBeCanceled(true);
            }
            tasks.add(info);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskModyficationListener(TaskModificationListener listener) {
        Set<TaskModificationListener> set = this.taskListeners;
        synchronized (set) {
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeTaskModyficationListener(TaskModificationListener listener) {
        Set<TaskModificationListener> set = this.taskListeners;
        synchronized (set) {
            this.taskListeners.remove(listener);
        }
    }

    @Override
    public synchronized Collection<String> getTasksDeletedSince(String userId, Date deletedSince) {
        HashSet<String> deletedTasks = new HashSet<String>();
        List<TaskDeletion> taskDeletionsList = this.taskDeletions.get(userId);
        if (taskDeletionsList == null || deletedSince == null) {
            return deletedTasks;
        }
        int i = taskDeletionsList.size() - 1;
        while (i > 0) {
            if (taskDeletionsList.get((int)i).deletionDate.before(deletedSince)) {
                return deletedTasks;
            }
            deletedTasks.add(taskDeletionsList.get((int)i).taskId);
            --i;
        }
        return deletedTasks;
    }

    private class DeletedTasksNotificationJob
    extends Job {
        private String userId;
        private Date deletionDate;

        public DeletedTasksNotificationJob(String userId, Date deletionDate) {
            super("Notyfing task listeners");
            this.userId = userId;
            this.deletionDate = deletionDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set set = TaskService.this.taskListeners;
            synchronized (set) {
                for (TaskModificationListener listener : TaskService.this.taskListeners) {
                    listener.tasksDeleted(this.userId, this.deletionDate);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class TaskDeletion {
        public final Date deletionDate;
        public final String taskId;

        public TaskDeletion(Date deletionDate, String taskId) {
            this.deletionDate = deletionDate;
            this.taskId = taskId;
        }
    }

    private class TasksNotificationJob
    extends Job {
        private String userId;
        private Date modificationDate;

        public TasksNotificationJob(String userId, Date modificationDate) {
            super("Notyfing task listeners");
            this.userId = userId;
            this.modificationDate = modificationDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set set = TaskService.this.taskListeners;
            synchronized (set) {
                for (TaskModificationListener listener : TaskService.this.taskListeners) {
                    listener.tasksModified(this.userId, this.modificationDate);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

