/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsReader;
import org.eclipse.jgit.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.storage.dfs.DfsRepository;
import org.eclipse.jgit.storage.file.PackIndex;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.io.CountingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsGarbageCollector {
    private final DfsRepository repo;
    private final DfsRefDatabase refdb;
    private final DfsObjDatabase objdb;
    private final List<DfsPackDescription> newPackDesc;
    private final List<PackWriter.Statistics> newPackStats;
    private final List<DfsPackFile> newPackList;
    private DfsReader ctx;
    private PackConfig packConfig;
    private Map<String, Ref> refsBefore;
    private List<DfsPackFile> packsBefore;
    private Set<ObjectId> allHeads;
    private Set<ObjectId> nonHeads;
    private long objectsBefore;
    private long objectsPacked;
    private Set<ObjectId> tagTargets;

    public DfsGarbageCollector(DfsRepository repository) {
        this.repo = repository;
        this.refdb = this.repo.getRefDatabase();
        this.objdb = this.repo.getObjectDatabase();
        this.newPackDesc = new ArrayList<DfsPackDescription>(4);
        this.newPackStats = new ArrayList<PackWriter.Statistics>(4);
        this.newPackList = new ArrayList<DfsPackFile>(4);
        this.packConfig = new PackConfig(this.repo);
        this.packConfig.setIndexVersion(2);
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public DfsGarbageCollector setPackConfig(PackConfig newConfig) {
        this.packConfig = newConfig;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pack(ProgressMonitor pm) throws IOException {
        boolean bl;
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        if (this.packConfig.getIndexVersion() != 2) {
            throw new IllegalStateException("Only index version 2");
        }
        this.ctx = (DfsReader)this.objdb.newReader();
        try {
            this.refdb.clearCache();
            this.objdb.clearCache();
            this.refsBefore = this.repo.getAllRefs();
            this.packsBefore = Arrays.asList(this.objdb.getPacks());
            if (this.packsBefore.isEmpty()) {
                boolean bl2 = true;
                Object var7_5 = null;
                this.ctx.release();
                return bl2;
            }
            this.allHeads = new HashSet<ObjectId>();
            this.nonHeads = new HashSet<ObjectId>();
            this.tagTargets = new HashSet<ObjectId>();
            for (Ref ref : this.refsBefore.values()) {
                if (ref.isSymbolic() || ref.getObjectId() == null) continue;
                if (DfsGarbageCollector.isHead(ref)) {
                    this.allHeads.add(ref.getObjectId());
                } else {
                    this.nonHeads.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                this.tagTargets.add(ref.getPeeledObjectId());
            }
            this.tagTargets.addAll(this.allHeads);
            boolean rollback = true;
            try {
                this.packHeads(pm);
                this.packRest(pm);
                this.packGarbage(pm);
                this.objdb.commitPack(this.newPackDesc, this.toPrune());
                rollback = false;
                bl = true;
                Object var5_10 = null;
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                if (!rollback) throw throwable;
                this.objdb.rollbackPack(this.newPackDesc);
                throw throwable;
            }
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            this.ctx.release();
            throw throwable2;
        }
        Object var7_6 = null;
        this.ctx.release();
        return bl;
    }

    public List<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPackDesc;
    }

    public List<PackWriter.Statistics> getNewPackStatistics() {
        return this.newPackStats;
    }

    private List<DfsPackDescription> toPrune() {
        int cnt = this.packsBefore.size();
        ArrayList<DfsPackDescription> all = new ArrayList<DfsPackDescription>(cnt);
        for (DfsPackFile pack : this.packsBefore) {
            all.add(pack.getPackDescription());
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packHeads(ProgressMonitor pm) throws IOException {
        if (this.allHeads.isEmpty()) {
            return;
        }
        PackWriter pw = this.newPackWriter();
        try {
            pw.preparePack(pm, this.allHeads, Collections.emptySet());
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC, pw, pm).setTips(this.allHeads);
            }
            Object var4_3 = null;
            pw.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            pw.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packRest(ProgressMonitor pm) throws IOException {
        if (this.nonHeads.isEmpty() || this.objectsPacked == this.getObjectsBefore()) {
            return;
        }
        PackWriter pw = this.newPackWriter();
        try {
            for (DfsPackFile pack : this.newPackList) {
                pw.excludeObjects(pack.getPackIndex(this.ctx));
            }
            pw.preparePack(pm, this.nonHeads, this.allHeads);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC, pw, pm);
            }
            Object var6_5 = null;
            pw.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            pw.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packGarbage(ProgressMonitor pm) throws IOException {
        if (this.objectsPacked == this.getObjectsBefore()) {
            return;
        }
        ArrayList<PackIndex> newIdx = new ArrayList<PackIndex>(this.newPackList.size());
        for (DfsPackFile pack : this.newPackList) {
            newIdx.add(pack.getPackIndex(this.ctx));
        }
        PackWriter pw = this.newPackWriter();
        try {
            RevWalk pool = new RevWalk(this.ctx);
            for (DfsPackFile oldPack : this.packsBefore) {
                PackIndex oldIdx = oldPack.getPackIndex(this.ctx);
                pm.beginTask("Finding garbage", (int)oldIdx.getObjectCount());
                for (PackIndex.MutableEntry ent : oldIdx) {
                    pm.update(1);
                    ObjectId id = ent.toObjectId();
                    if (pool.lookupOrNull(id) != null || DfsGarbageCollector.anyIndexHas(newIdx, id)) continue;
                    int type = oldPack.getObjectType(this.ctx, ent.getOffset());
                    pw.addObject(pool.lookupAny(id, type));
                }
                pm.endTask();
            }
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE, pw, pm);
            }
            Object var13_12 = null;
            pw.release();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            pw.release();
            throw throwable;
        }
    }

    private static boolean anyIndexHas(List<PackIndex> list, AnyObjectId id) {
        for (PackIndex idx : list) {
            if (!idx.hasObject(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private long getObjectsBefore() {
        if (this.objectsBefore == 0L) {
            for (DfsPackFile p : this.packsBefore) {
                this.objectsBefore += p.getPackDescription().getObjectCount();
            }
        }
        return this.objectsBefore;
    }

    private PackWriter newPackWriter() {
        PackWriter pw = new PackWriter(this.packConfig, (ObjectReader)this.ctx);
        pw.setDeltaBaseAsOffset(true);
        pw.setReuseDeltaCommits(false);
        pw.setTagTargets(this.tagTargets);
        return pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfsPackDescription writePack(DfsObjDatabase.PackSource source, PackWriter pw, ProgressMonitor pm) throws IOException {
        DfsPackDescription pack = this.repo.getObjectDatabase().newPack(source);
        this.newPackDesc.add(pack);
        DfsOutputStream out = this.objdb.writePackFile(pack);
        try {
            pw.writePack(pm, pm, out);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            out.close();
            throw throwable;
        }
        out.close();
        out = this.objdb.writePackIndex(pack);
        try {
            CountingOutputStream cnt = new CountingOutputStream(out);
            pw.writeIndex(cnt);
            pack.setIndexSize(cnt.getCount());
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            out.close();
            throw throwable;
        }
        out.close();
        PackWriter.Statistics stats = pw.getStatistics();
        pack.setPackStats(stats);
        pack.setPackSize(stats.getTotalBytes());
        pack.setObjectCount(stats.getTotalObjects());
        pack.setDeltaCount(stats.getTotalDeltas());
        this.objectsPacked += stats.getTotalObjects();
        this.newPackStats.add(stats);
        this.newPackList.add(DfsBlockCache.getInstance().getOrCreate(pack, null));
        return pack;
    }
}

