/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.FetchJob;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;

public class PullJob
extends GitJob {
    private IPath path;
    private String projectName;

    public PullJob(String userRunningTask, CredentialsProvider credentials, Path path, boolean force) {
        super("Pulling", userRunningTask, "Pulling...", false, false, (GitCredentialsProvider)credentials);
        this.path = path;
        this.projectName = path.segmentCount() == 2 ? WebProject.fromId((String)path.segment(1)).getName() : path.lastSegment();
        this.setName(NLS.bind((String)"Pulling {0}", (Object)this.projectName));
        this.setMessage(NLS.bind((String)"Pulling {0}...", (Object)this.projectName));
        this.setFinalMessage(NLS.bind((String)"Pulling {0} done", (Object)this.projectName));
    }

    private IStatus doPull() throws IOException, CoreException, JGitInternalException, URISyntaxException, GitAPIException {
        FileRepository db = new FileRepository(GitUtils.getGitDir(this.path));
        Git git = new Git((Repository)db);
        PullCommand pc = git.pull();
        pc.setCredentialsProvider((CredentialsProvider)this.credentials);
        pc.setTransportConfigCallback(new TransportConfigCallback(){

            public void configure(Transport t) {
                PullJob.this.credentials.setUri(t.getURI());
            }
        });
        PullResult pullResult = pc.call();
        if (pullResult.isSuccessful()) {
            return Status.OK_STATUS;
        }
        FetchResult fetchResult = pullResult.getFetchResult();
        IStatus fetchStatus = FetchJob.handleFetchResult(fetchResult);
        if (!fetchStatus.isOK()) {
            return fetchStatus;
        }
        MergeResult.MergeStatus mergeStatus = pullResult.getMergeResult().getMergeStatus();
        if (mergeStatus.isSuccessful()) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.orion.server.git", mergeStatus.name());
    }

    protected IStatus performJob() {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doPull();
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Pulling error", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (JGitInternalException e) {
            result = this.getJGitInternalExceptionStatus(e, "An internal pulling error");
        }
        catch (GitAPIException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Pulling error", (Throwable)e);
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Pulling error", (Throwable)e);
        }
        return result;
    }
}

