/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class Diff
extends GitObject {
    public static final String RESOURCE = "diff";
    public static final String TYPE = "Diff";
    private URI baseLocation;

    public Diff(URI baseLocation, Repository db) throws URISyntaxException, CoreException {
        super(BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.DIFF), db);
        this.baseLocation = baseLocation;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        IPath path = new Path(this.baseLocation.getPath()).removeFirstSegments(2);
        JSONObject diff = super.toJSON();
        diff.put("Old", (Object)this.getOldLocation(this.baseLocation, path));
        diff.put("New", (Object)this.getNewLocation(this.baseLocation, path));
        diff.put("Base", (Object)this.getBaseLocation(this.baseLocation, this.db, path));
        return diff;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return this.baseLocation;
    }

    private URI getOldLocation(URI location, IPath path) throws URISyntaxException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException(NLS.bind((String)"Illegal scope format, expected {old}..{new}, was {0}", (Object)scope));
            }
            IPath p = new Path("/gitapi/commit").append(commits[0]).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/commit").append("HEAD").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Default")) {
            IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
        }
        IPath p = new Path("/gitapi/commit").append(scope).append(path.removeFirstSegments(1));
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
    }

    private URI getNewLocation(URI location, IPath path) throws URISyntaxException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException(NLS.bind((String)"Illegal scope format, expected {old}..{new}, was {0}", (Object)scope));
            }
            IPath p = new Path("/gitapi/commit").append(commits[1]).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
        }
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), path.removeFirstSegments(1).makeAbsolute().toString(), null, null);
    }

    private URI getBaseLocation(URI location, Repository db, IPath path) throws URISyntaxException, IOException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException(NLS.bind((String)"Illegal scope format, expected {old}..{new}, was {0}", (Object)scope));
            }
            ResolveMerger merger = new ResolveMerger(db){

                protected boolean mergeImpl() throws IOException {
                    return false;
                }
            };
            merger.merge((AnyObjectId[])new ObjectId[]{db.resolve(commits[0]), db.resolve(commits[1])});
            RevCommit baseCommit = merger.getBaseCommit(0, 1);
            IPath p = new Path("/gitapi/commit").append(baseCommit.getId().getName()).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/commit").append("HEAD").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
    }

    @Override
    protected String getType() {
        return TYPE;
    }
}

