/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.patch;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.server.git.patch.ApplyResult;
import org.eclipse.orion.server.git.patch.HunkControlChar;
import org.eclipse.orion.server.git.patch.PatchApplyException;
import org.eclipse.orion.server.git.patch.PatchFormatException;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    public ApplyCommand(Repository repo) {
        super(repo);
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    public ApplyResult call() throws Exception {
        this.checkCallable();
        ApplyResult r = new ApplyResult();
        try {
            try {
                Patch p = new Patch();
                try {
                    p.parse(this.in);
                }
                finally {
                    this.in.close();
                }
                if (!p.getErrors().isEmpty()) {
                    throw new PatchFormatException(p.getErrors());
                }
                for (FileHeader fh : p.getFiles()) {
                    DiffEntry.ChangeType type = fh.getChangeType();
                    File f = null;
                    switch (type) {
                        case ADD: {
                            f = this.getFile(fh.getNewPath(), true);
                            this.apply(f, fh);
                            break;
                        }
                        case MODIFY: {
                            f = this.getFile(fh.getOldPath(), false);
                            this.apply(f, fh);
                            break;
                        }
                        case DELETE: {
                            f = this.getFile(fh.getOldPath(), false);
                            if (f.delete()) break;
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, f));
                        }
                        case RENAME: {
                            f = this.getFile(fh.getOldPath(), false);
                            File dest = this.getFile(fh.getNewPath(), false);
                            if (f.renameTo(dest)) break;
                            throw new PatchApplyException(MessageFormat.format("Could not rename file {0} to {1}", f, dest));
                        }
                        case COPY: {
                            f = this.getFile(fh.getOldPath(), false);
                            byte[] bs = IO.readFully((File)f);
                            FileWriter fw = new FileWriter(this.getFile(fh.getNewPath(), true));
                            fw.write(new String(bs));
                            fw.close();
                        }
                    }
                    r.addUpdatedFile(f);
                }
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format("Cannot apply: {0}", e.getMessage()), e);
            }
        }
        finally {
            IOUtilities.safeClose((Closeable)this.in);
        }
        this.setCallable(false);
        return r;
    }

    private File getFile(String path, boolean create) throws IOException, PatchApplyException {
        File f = new File(this.getRepository().getWorkTree(), path);
        if (create) {
            try {
                FileUtils.createNewFile((File)f);
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format("Could not create new file {0}", f), e);
            }
        }
        return f;
    }

    private void apply(File f, FileHeader fh) throws IOException, PatchApplyException {
        OrionRawText rt = new OrionRawText(f);
        ArrayList<String> oldLines = new ArrayList<String>(rt.size());
        int i = 0;
        while (i < rt.size()) {
            oldLines.add(rt.getString(i));
            ++i;
        }
        ArrayList<String> newLines = new ArrayList<String>(oldLines);
        for (HunkHeader hh : fh.getHunks()) {
            StringBuilder hunk = new StringBuilder();
            int j = hh.getStartOffset();
            while (j < hh.getEndOffset()) {
                hunk.append((char)hh.getBuffer()[j]);
                ++j;
            }
            OrionRawText hrt = new OrionRawText(hunk.toString().getBytes());
            ArrayList<String> hunkLines = new ArrayList<String>(hrt.size());
            int i2 = 0;
            while (i2 < hrt.size()) {
                hunkLines.add(hrt.getString(i2));
                ++i2;
            }
            int pos = 0;
            int j2 = 1;
            while (j2 < hunkLines.size()) {
                String hunkLine = (String)hunkLines.get(j2);
                switch (HunkControlChar.valueOf(hunkLine.charAt(0))) {
                    case CONTEXT: {
                        if (!((String)newLines.get(hh.getNewStartLine() - 1 + pos)).equals(hunkLine.substring(1))) {
                            throw new PatchApplyException(MessageFormat.format("Cannot apply: {0}", hh));
                        }
                        ++pos;
                        break;
                    }
                    case REMOVE: {
                        if (!((String)newLines.get(hh.getNewStartLine() - 1 + pos)).equals(hunkLine.substring(1))) {
                            throw new PatchApplyException(MessageFormat.format("Cannot apply: {0}", hh));
                        }
                        newLines.remove(hh.getNewStartLine() - 1 + pos);
                        break;
                    }
                    case ADD: {
                        newLines.add(hh.getNewStartLine() - 1 + pos, hunkLine.substring(1));
                        ++pos;
                    }
                }
                ++j2;
            }
        }
        if (!this.isNoNewlineAtEndOfFile(fh)) {
            newLines.add("");
        }
        if (!rt.isMissingNewlineAtEnd()) {
            oldLines.add("");
        }
        if (!this.isChanged(oldLines, newLines)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String eol = rt.size() == 0 || rt.size() == 1 && rt.isMissingNewlineAtEnd() ? "\n" : rt.getEOL();
        for (String l : newLines) {
            sb.append(l);
            if (eol == null) continue;
            sb.append(eol);
        }
        sb.deleteCharAt(sb.length() - 1);
        FileWriter fw = new FileWriter(f);
        fw.write(sb.toString());
        fw.close();
    }

    private boolean isChanged(List<String> ol, List<String> nl) {
        if (ol.size() != nl.size()) {
            return true;
        }
        int i = 0;
        while (i < ol.size()) {
            if (!ol.get(i).equals(nl.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fh) {
        HunkHeader lastHunk = (HunkHeader)fh.getHunks().get(fh.getHunks().size() - 1);
        RawText lhrt = new RawText(lastHunk.getBuffer());
        return lhrt.getString(lhrt.size() - 1).equals("\\ No newline at end of file");
    }

    private class OrionRawText
    extends RawText {
        public OrionRawText(File f) throws IOException {
            super(f);
        }

        public OrionRawText(byte[] bytes) {
            super(bytes);
        }

        private int getEnd(int i) {
            return this.lines.get(i + 2);
        }

        private int getStart(int i) {
            return this.lines.get(i + 1);
        }

        public String getString(int begin, int end, boolean dropLineEnding) {
            if (begin == end) {
                return "";
            }
            int s = this.getStart(begin);
            int e = this.getEnd(end - 1);
            if (dropLineEnding && this.content.length > 1 && this.content[e - 2] == 13 && this.content[e - 1] == 10) {
                e -= 2;
            } else if (dropLineEnding && this.content[e - 1] == 10) {
                --e;
            }
            return this.decode(s, e);
        }

        public String getEOL() {
            int e = this.getEnd(0);
            if (this.content.length > 1 && this.content[e - 2] == 13 && this.content[e - 1] == 10) {
                return "\r\n";
            }
            if (this.content.length > 0 && this.content[e - 1] == 10) {
                return "\n";
            }
            return null;
        }
    }
}

