/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.search.SearchActivator;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexer
extends Job {
    private static final long DEFAULT_DELAY = 60000L;
    private static final long IDLE_DELAY = 300000L;
    private static final long MAX_SEARCH_SIZE = 300000L;
    private final List<String> INDEXED_FILE_TYPES;
    private final SolrServer server;

    public Indexer(SolrServer server) {
        super("Indexing");
        this.server = server;
        this.setSystem(true);
        this.INDEXED_FILE_TYPES = Arrays.asList("css", "js", "html", "txt", "xml", "java", "properties", "php", "htm", "project", "conf", "pl", "sh", "text", "xhtml", "mf", "manifest");
        Collections.sort(this.INDEXED_FILE_TYPES);
    }

    public boolean belongsTo(Object family) {
        return SearchActivator.JOB_FAMILY.equals(family);
    }

    private void collectFiles(IFileStore dir, List<IFileStore> files) {
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = dir.childStores(0, null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                if (!child.getName().startsWith(".")) {
                    IFileInfo info = child.fetchInfo();
                    if (info.isDirectory()) {
                        this.collectFiles(child, files);
                    } else if (!this.skip(info)) {
                        files.add(child);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.handleIndexingFailure(e);
        }
    }

    public void ensureUpdated() {
        this.schedule(60000L);
    }

    private String getContentsAsString(IFileStore file) {
        StringWriter writer = new StringWriter();
        try {
            IOUtilities.pipe((Reader)new InputStreamReader(file.openInputStream(0, null)), (Writer)writer, (boolean)true, (boolean)false);
        }
        catch (IOException e) {
            this.handleIndexingFailure(e);
        }
        catch (CoreException e) {
            this.handleIndexingFailure(e);
        }
        return writer.toString();
    }

    private void handleIndexingFailure(Throwable t) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.search", "Error during search indexing", t));
    }

    private int indexProject(WebProject project, SubMonitor monitor, List<SolrInputDocument> documents) {
        IFileStore projectStore;
        Logger logger = LoggerFactory.getLogger(Indexer.class);
        if (logger.isDebugEnabled()) {
            logger.debug("Indexing project id: " + project.getId() + " name: " + project.getName());
        }
        this.checkCanceled((IProgressMonitor)monitor);
        try {
            projectStore = project.getProjectStore();
        }
        catch (CoreException e) {
            this.handleIndexingFailure(e);
            return 0;
        }
        IPath projectLocation = new Path("/file").append(project.getId()).addTrailingSeparator();
        int projectLocationLength = projectStore.toURI().toString().length();
        ArrayList<IFileStore> toIndex = new ArrayList<IFileStore>();
        this.collectFiles(projectStore, toIndex);
        int unmodifiedCount = 0;
        int indexedCount = 0;
        List<String> users = this.findUsers(projectLocation);
        for (IFileStore file : toIndex) {
            this.checkCanceled((IProgressMonitor)monitor);
            IFileInfo fileInfo = file.fetchInfo();
            if (!this.isModified(file, fileInfo)) {
                ++unmodifiedCount;
                continue;
            }
            ++indexedCount;
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("Id", (Object)file.toURI().toString());
            doc.addField("Name", (Object)fileInfo.getName());
            doc.addField("Length", (Object)Long.toString(fileInfo.getLength()));
            doc.addField("Directory", (Object)Boolean.toString(fileInfo.isDirectory()));
            doc.addField("LastModified", (Object)Long.toString(fileInfo.getLastModified()));
            String projectRelativePath = file.toURI().toString().substring(projectLocationLength);
            IPath fileLocation = projectLocation.append(projectRelativePath);
            doc.addField("Location", (Object)fileLocation.toString());
            String projectName = project.getName();
            if (projectName == null) continue;
            doc.addField("Path", (Object)new Path(projectName).append(projectRelativePath));
            doc.addField("Text", (Object)this.getContentsAsString(file));
            if (users != null) {
                for (String user : users) {
                    doc.addField("UserName", (Object)user);
                }
            }
            try {
                this.server.add(doc);
            }
            catch (Exception e) {
                this.handleIndexingFailure(e);
            }
        }
        try {
            this.server.commit();
        }
        catch (Exception e) {
            this.handleIndexingFailure(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\tIndexed: " + indexedCount + " Unchanged:  " + unmodifiedCount);
        }
        return indexedCount;
    }

    private List<String> findUsers(IPath projectLocation) {
        return AuthorizationService.findUserWithRights((String)projectLocation.toString());
    }

    private boolean skip(IFileInfo fileInfo) {
        if (fileInfo.getLength() > 300000L) {
            return true;
        }
        String extension = new Path(fileInfo.getName()).getFileExtension();
        return extension == null || Collections.binarySearch(this.INDEXED_FILE_TYPES, extension.toLowerCase()) < 0;
    }

    private boolean isModified(IFileStore file, IFileInfo fileInfo) {
        try {
            StringBuffer qString = new StringBuffer("Id");
            qString.append(':');
            qString.append(ClientUtils.escapeQueryChars((String)file.toURI().toString()));
            qString.append(" AND ");
            qString.append("LastModified");
            qString.append(':');
            qString.append(Long.toString(fileInfo.getLastModified()));
            SolrQuery query = new SolrQuery(qString.toString());
            query.setParam("fl", new String[]{"Id"});
            QueryResponse response = this.server.query((SolrParams)query);
            return response.getResults().getNumFound() == 0L;
        }
        catch (SolrServerException e) {
            this.handleIndexingFailure(e);
            return true;
        }
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        List projects = WebProject.allProjects();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
        ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
        int indexed = 0;
        for (WebProject project : projects) {
            indexed += this.indexProject(project, progress.newChild(1), documents);
        }
        long duration = System.currentTimeMillis() - start;
        Logger logger = LoggerFactory.getLogger(Indexer.class);
        if (logger.isDebugEnabled()) {
            logger.debug("Indexed " + projects.size() + " projects in " + duration + "ms");
        }
        long delay = Math.max(60000L, duration * 10L);
        if (indexed == 0) {
            delay = Math.max(delay, 300000L);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Rescheduling indexing in " + delay + "ms");
        }
        this.schedule(delay);
        return Status.OK_STATUS;
    }
}

