/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Remote;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Branch
extends GitObject {
    public static final String RESOURCE = "branch";
    public static final String TYPE = "Branch";
    public static final Comparator<Branch> COMPARATOR = new Comparator<Branch>(){

        @Override
        public int compare(Branch o1, Branch o2) {
            return o1.getTime() < o2.getTime() ? 1 : (o1.getTime() > o2.getTime() ? -1 : o2.getName().compareTo(o1.getName()));
        }
    };
    private Ref ref;

    public Branch(URI cloneLocation, Repository db, Ref ref) {
        super(cloneLocation, db);
        this.ref = ref;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = super.toJSON();
        String shortName = this.getName();
        result.put("Name", (Object)shortName);
        result.put("CommitLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, shortName, BaseToCommitConverter.REMOVE_FIRST_2));
        result.put("RemoteLocation", (Object)this.getRemotes());
        result.put("HeadLocation", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_2));
        result.put("Current", shortName.equals(this.db.getBranch()));
        result.put("LocalTimeStamp", (long)this.getTime() * 1000L);
        return result;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        String shortName = this.getName();
        Path basePath = new Path(this.cloneLocation.getPath());
        IPath newPath = new Path("/gitapi").append(RESOURCE).append(shortName).append(basePath.removeFirstSegments(2));
        URI location = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), newPath.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        return location;
    }

    public JSONObject toJSON(JSONObject log) throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = this.toJSON();
        result.put("Commit", (Object)log);
        return result;
    }

    private JSONArray getRemotes() throws URISyntaxException, JSONException, IOException, CoreException {
        String branchName = Repository.shortenRefName((String)this.ref.getName());
        JSONArray result = new JSONArray();
        String remote = this.getConfig().getString(RESOURCE, branchName, "remote");
        if (remote != null) {
            RemoteConfig remoteConfig = new RemoteConfig((Config)this.getConfig(), remote);
            if (!remoteConfig.getFetchRefSpecs().isEmpty()) {
                result.put((Object)new Remote(this.cloneLocation, this.db, remote).toJSON(branchName));
            }
        } else {
            List remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.getConfig());
            for (RemoteConfig remoteConfig : remoteConfigs) {
                if (remoteConfig.getFetchRefSpecs().isEmpty()) continue;
                Remote r = new Remote(this.cloneLocation, this.db, remoteConfig.getName());
                if (this.db.resolve("refs/remotes/" + remoteConfig.getName() + "/" + branchName) != null) {
                    return new JSONArray().put((Object)r.toJSON(branchName));
                }
                result.put((Object)r.toJSON(branchName));
            }
        }
        return result;
    }

    public String getName() {
        return Repository.shortenRefName((String)this.ref.getName());
    }

    public int getTime() {
        RevCommit c = this.parseCommit();
        if (c != null) {
            return c.getCommitTime();
        }
        return 0;
    }

    private RevCommit parseCommit() {
        ObjectId oid = this.ref.getObjectId();
        if (oid == null) {
            return null;
        }
        RevWalk walk = new RevWalk(this.db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        catch (IOException iOException) {
        }
        finally {
            walk.release();
        }
        return null;
    }

    public String toString() {
        return "Branch [ref=" + this.ref + "]";
    }

    @Override
    protected String getType() {
        return TYPE;
    }
}

