/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.jobs.ListBranchesJob;
import org.eclipse.orion.server.git.objects.Branch;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class GitBranchHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;
    public static int PAGE_SIZE = 50;

    GitBranchHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitBranchHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        if (p.segment(0).equals("file")) {
            ListBranchesJob job;
            String commits = request.getParameter("commits");
            int commitsNumber = commits == null ? 0 : Integer.parseInt(commits);
            String page = request.getParameter("page");
            if (page != null) {
                int pageNo = Integer.parseInt(page);
                int pageSize = request.getParameter("pageSize") == null ? PAGE_SIZE : Integer.parseInt(request.getParameter("pageSize"));
                job = new ListBranchesJob(TaskJobHandler.getUserId((HttpServletRequest)request), (IPath)p, BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST), commitsNumber, pageNo, pageSize, request.getRequestURI());
            } else {
                job = new ListBranchesJob(TaskJobHandler.getUserId((HttpServletRequest)request), (IPath)p, BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST), commitsNumber);
            }
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
        }
        if (p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileRepository db = new FileRepository(gitDir);
            Git git = new Git((Repository)db);
            List branches = git.branchList().call();
            JSONObject result = null;
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH);
            for (Ref ref : branches) {
                if (!Repository.shortenRefName((String)ref.getName()).equals(p.segment(0))) continue;
                result = new Branch(cloneLocation, (Repository)db, ref).toJSON();
                break;
            }
            if (result == null) {
                String msg = NLS.bind((String)"Branch {0} not found", (Object)p.segment(0));
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
            }
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, result);
            return true;
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, JGitInternalException, GitAPIException {
        Path p = new Path(path);
        if (p.segment(0).equals("file")) {
            JSONObject toCreate = OrionServlet.readJSONRequest((HttpServletRequest)request);
            String branchName = toCreate.optString("Name", null);
            String startPoint = toCreate.optString("Branch", null);
            if (branchName == null || branchName.isEmpty()) {
                if (startPoint == null || startPoint.isEmpty()) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Branch name must be provided", null));
                }
                String shortName = Repository.shortenRefName((String)startPoint);
                branchName = shortName.substring(shortName.lastIndexOf("/") + 1);
            }
            File gitDir = GitUtils.getGitDir((IPath)p);
            FileRepository db = new FileRepository(gitDir);
            Git git = new Git((Repository)db);
            CreateBranchCommand cc = git.branchCreate();
            cc.setName(branchName);
            if (startPoint != null && !startPoint.isEmpty()) {
                cc.setStartPoint(startPoint);
                cc.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
            }
            Ref ref = cc.call();
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitBranchHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST);
            JSONObject result = new Branch(cloneLocation, (Repository)db, ref).toJSON();
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", result.getString("Location"));
            response.setStatus(201);
            return true;
        }
        String msg = NLS.bind((String)"Failed to create a branch for {0}", (Object)path);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, JGitInternalException, GitAPIException {
        Path p = new Path(path);
        if (p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileRepository db = new FileRepository(gitDir);
            Git git = new Git((Repository)db);
            DeleteBranchCommand cc = git.branchDelete();
            cc.setBranchNames(new String[]{p.segment(0)});
            cc.setForce(true);
            cc.call();
            return true;
        }
        return false;
    }
}

