/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.objects.Tag;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListTagsJob
extends GitJob {
    private IPath path;
    private URI cloneLocation;
    private int commitsSize;
    private int pageNo;
    private int pageSize;
    private String baseLocation;

    public ListTagsJob(String userRunningTask, IPath repositoryPath, URI cloneLocation, int commitsSize, int pageNo, int pageSize, String baseLocation) {
        super(NLS.bind((String)"Generating tags list for {0}", (Object)repositoryPath), userRunningTask, NLS.bind((String)"Generating tags list for {0}...", (Object)repositoryPath), true, false);
        this.path = repositoryPath;
        this.cloneLocation = cloneLocation;
        this.commitsSize = commitsSize;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.baseLocation = baseLocation;
        this.setFinalMessage("Generating tags list completed");
    }

    public ListTagsJob(String userRunningTask, IPath repositoryPath, URI cloneLocation, int commitsSize) {
        this(userRunningTask, repositoryPath, cloneLocation, commitsSize, 1, -1, null);
    }

    public ListTagsJob(String userRunningTask, IPath repositoryPath, URI cloneLocation) {
        this(userRunningTask, repositoryPath, cloneLocation, 0);
    }

    private ObjectId getCommitObjectId(Repository db, ObjectId oid) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk walk = new RevWalk(db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        finally {
            walk.release();
        }
    }

    protected IStatus performJob() {
        try {
            File gitDir = GitUtils.getGitDir(this.path);
            FileRepository db = new FileRepository(gitDir);
            Map refs = db.getRefDatabase().getRefs("refs/tags/");
            JSONObject result = new JSONObject();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (Map.Entry refEntry : refs.entrySet()) {
                Tag tag = new Tag(this.cloneLocation, (Repository)db, (Ref)refEntry.getValue());
                tags.add(tag);
            }
            Collections.sort(tags, Tag.COMPARATOR);
            JSONArray children = new JSONArray();
            Git git = new Git((Repository)db);
            int firstTag = this.pageSize > 0 ? this.pageSize * (this.pageNo - 1) : 0;
            int lastTag = this.pageSize > 0 ? firstTag + this.pageSize - 1 : tags.size() - 1;
            int n = lastTag = lastTag > tags.size() - 1 ? tags.size() - 1 : lastTag;
            if (this.pageNo > 1 && this.baseLocation != null) {
                String prev = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo - 1) + "&pageSize=" + this.pageSize;
                if (this.commitsSize > 0) {
                    prev = String.valueOf(prev) + "&commits=" + this.commitsSize;
                }
                result.put("PreviousLocation", (Object)prev);
            }
            if (lastTag < tags.size() - 1) {
                String next = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo + 1) + "&pageSize=" + this.pageSize;
                if (this.commitsSize > 0) {
                    next = String.valueOf(next) + "&commits=" + this.commitsSize;
                }
                result.put("NextLocation", (Object)next);
            }
            int i = firstTag;
            while (i <= lastTag) {
                Tag tag = (Tag)tags.get(i);
                if (this.commitsSize == 0) {
                    children.put((Object)tag.toJSON());
                } else {
                    LogCommand lc = git.log();
                    String toCommitName = tag.getRevCommitName();
                    ObjectId toCommitId = db.resolve(toCommitName);
                    Ref toCommitRef = db.getRef(toCommitName);
                    toCommitId = this.getCommitObjectId((Repository)db, toCommitId);
                    lc.add((AnyObjectId)toCommitId);
                    lc.setMaxCount(this.commitsSize);
                    Iterable commits = lc.call();
                    Log log = new Log(this.cloneLocation, (Repository)db, commits, null, null, toCommitRef);
                    children.put((Object)tag.toJSON(log.toJSON(1, this.commitsSize)));
                }
                ++i;
            }
            result.put("Children", (Object)children);
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when listing tags for {0}", (Object)this.path);
            return new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
        }
    }
}

