/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.json.JSONException;
import org.json.JSONObject;

public class Clone {
    public static final String RESOURCE = "clone";
    public static final String TYPE = "Clone";
    private String id;
    private URI contentLocation;
    private URIish uriish;
    private String name;
    private FileRepository db;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setContentLocation(URI contentURI) {
        this.contentLocation = contentURI;
    }

    public URI getContentLocation() {
        return this.contentLocation;
    }

    public void setUrl(URIish gitURI) {
        this.uriish = gitURI;
    }

    public String getUrl() {
        return this.uriish.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private FileRepository getRepository() throws IOException {
        if (this.db == null) {
            this.db = new FileRepository(new File(new File(this.getContentLocation()), ".git"));
        }
        return this.db;
    }

    public JSONObject toJSON(URI baseLocation) throws JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        try {
            result.put("Id", (Object)this.getId());
            result.put("Name", (Object)this.getName());
            result.put("Type", (Object)TYPE);
            IPath np = new Path("/gitapi").append(RESOURCE).append("file").append(this.getId());
            URI location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("Location", (Object)location);
            np = new Path("file").append(this.getId()).makeAbsolute();
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("ContentLocation", (Object)location);
            np = new Path("/gitapi").append("remote").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("RemoteLocation", (Object)location);
            np = new Path("/gitapi").append("config").append(RESOURCE).append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("ConfigLocation", (Object)location);
            np = new Path("/gitapi").append("commit").append("HEAD").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("HeadLocation", (Object)location);
            np = new Path("/gitapi").append("commit").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("CommitLocation", (Object)location);
            np = new Path("/gitapi").append("branch").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("BranchLocation", (Object)location);
            np = new Path("/gitapi").append("tag").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("TagLocation", (Object)location);
            np = new Path("/gitapi").append("index").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("IndexLocation", (Object)location);
            np = new Path("/gitapi").append("status").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("StatusLocation", (Object)location);
            np = new Path("/gitapi").append("diff").append("Default").append("file").append(this.getId());
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("DiffLocation", (Object)location);
            try {
                FileBasedConfig config = this.getRepository().getConfig();
                String remoteUri = config.getString("remote", "origin", "url");
                if (remoteUri != null) {
                    result.put("GitUrl", (Object)remoteUri);
                }
            }
            catch (IOException iOException) {}
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public JSONObject toJSON(Map.Entry<IPath, File> entry, URI baseLocation) throws JSONException, IOException, URISyntaxException {
        this.id = entry.getKey().toString();
        this.name = entry.getKey().segmentCount() == 1 ? WebProject.fromId((String)entry.getKey().segment(0)).getName() : entry.getKey().lastSegment();
        this.db = new FileRepository(entry.getValue());
        return this.toJSON(baseLocation);
    }
}

