/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.RemoteBranch;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Remote
extends GitObject {
    public static final String RESOURCE = "remote";
    public static final String TYPE = "Remote";
    private String name;

    public Remote(URI cloneLocation, Repository db, String name) {
        super(cloneLocation, db);
        this.name = name;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return this.toJSON(true, null);
    }

    public JSONObject toJSON(String newBranch) throws JSONException, URISyntaxException, IOException, CoreException {
        return this.toJSON(true, newBranch);
    }

    public JSONObject toJSON(boolean includeChildren, String newBranch) throws JSONException, URISyntaxException, IOException, CoreException {
        this.check();
        JSONObject result = super.toJSON();
        result.put("Name", (Object)this.name);
        result.put("GitUrl", (Object)this.getConfig().getString(RESOURCE, this.name, "url"));
        result.put("PushUrl", (Object)this.getConfig().getString(RESOURCE, this.name, "pushurl"));
        if (includeChildren) {
            JSONArray children = new JSONArray();
            boolean branchFound = false;
            ArrayList<Ref> refs = new ArrayList<Ref>();
            String currentBranch = this.db.getBranch();
            for (Map.Entry refEntry : this.db.getRefDatabase().getRefs("refs/remotes/" + this.name + "/").entrySet()) {
                if (((Ref)refEntry.getValue()).isSymbolic()) continue;
                Ref ref = (Ref)refEntry.getValue();
                String name = ref.getName();
                if (currentBranch.equals(name = Repository.shortenRefName((String)name).substring("origin".length() + 1))) {
                    refs.add(0, ref);
                    continue;
                }
                refs.add(ref);
            }
            for (Ref ref : refs) {
                String remoteBranchName = Repository.shortenRefName((String)ref.getName());
                remoteBranchName = remoteBranchName.substring((String.valueOf(this.name) + "/").length());
                RemoteBranch remoteBranch = new RemoteBranch(this.cloneLocation, this.db, this, remoteBranchName);
                children.put((Object)remoteBranch.toJSON());
                if (newBranch == null || newBranch.isEmpty() || !remoteBranchName.equals(newBranch)) continue;
                children = new JSONArray().put((Object)remoteBranch.toJSON());
                branchFound = true;
                break;
            }
            if (!branchFound && newBranch != null && !newBranch.isEmpty()) {
                JSONObject o = new JSONObject();
                String name = "refs/remotes/" + this.getName() + "/" + newBranch;
                o.put("Name", (Object)name.substring("refs/remotes/".length()));
                o.put("FullName", (Object)name);
                o.put("Type", (Object)"RemoteTrackingBranch");
                o.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(this.cloneLocation, "", Repository.shortenRefName((String)name)));
                children.put((Object)o);
            }
            result.put("Children", (Object)children);
        }
        return result;
    }

    @Override
    public URI getLocation() throws URISyntaxException {
        return BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(this.cloneLocation, this.name, "");
    }

    private void check() {
        if (!this.getConfig().getSubsections(RESOURCE).contains(this.name)) {
            throw new IllegalArgumentException(NLS.bind((String)"Remote {0} not found.", (Object)this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Remote [name=" + this.name + "]";
    }

    @Override
    protected String getType() {
        return TYPE;
    }
}

