/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.openid.core.OpenIdException;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.eclipse.orion.server.openid.core.OpenidConsumer;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenidServlet
extends HttpServlet {
    private static final long serialVersionUID = 2395713347747299772L;
    private OpenidConsumer consumer;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String openid = req.getParameter("openid");
            if (openid != null) {
                this.consumer = OpenIdHelper.redirectToOpenIdProvider((HttpServletRequest)req, (HttpServletResponse)resp, (OpenidConsumer)this.consumer);
                return;
            }
            String op_return = req.getParameter("op_return");
            if (op_return != null) {
                OpenIdHelper.handleOpenIdReturnAndLogin((HttpServletRequest)req, (HttpServletResponse)resp, (OpenidConsumer)this.consumer);
                OpenidServlet.writeLoginResponse(req, resp);
                return;
            }
        }
        catch (OpenIdException e) {
            OpenidServlet.writeOpenIdError(e.getMessage(), req, resp);
            return;
        }
        if (OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req) != null) {
            OpenIdHelper.writeLoginResponse((String)OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req), (HttpServletResponse)resp);
            return;
        }
        super.doGet(req, resp);
    }

    private static void writeOpenIdError(String error, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("redirect") == null) {
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/html; charset=UTF-8");
            out.println("<html><head></head>");
            out.print("<body onload=\"window.opener.handleOpenIDResponse((window.location+'').split('?')[1],'");
            out.print(error);
            out.println("');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<html><head></head>");
        String url = req.getParameter("redirect");
        url = url.replaceAll("/&error(\\=[^&]*)?(?=&|$)|^error(\\=[^&]*)?(&|$)/", "");
        out.print("<body onload=\"window.location.replace('");
        out.print(url.toString());
        if (url.contains("?")) {
            out.print("&error=");
        } else {
            out.print("?error=");
        }
        out.print(new String(Base64.encode((byte[])error.getBytes())));
        out.println("');\">");
        out.println("</body>");
        out.println("</html>");
    }

    private static void writeLoginResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String uid = (String)req.getSession().getAttribute("user");
        if (uid == null || "".equals(uid)) {
            return;
        }
        try {
            JSONObject userJson = FormAuthHelper.getUserJson((String)uid, (String)req.getContextPath());
            PrintWriter out = resp.getWriter();
            out.println("<html><head></head>");
            out.print("<body onload=\"localStorage.setItem('OpenIdSignInKey',  '");
            out.print(userJson.toString().replaceAll("\\\"", "&quot;"));
            out.println("');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req) != null) {
            OpenIdHelper.writeLoginResponse((String)OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req), (HttpServletResponse)resp);
            return;
        }
    }
}

