/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.ServletStatusHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrionServlet
extends HttpServlet {
    protected static final boolean DEBUG_VEBOSE = false;
    private static final long serialVersionUID = 1L;
    private static final ServletResourceHandler<IStatus> statusHandler = new ServletStatusHandler();

    private static String prettyPrint(Object result) {
        try {
            if (result instanceof JSONObject) {
                return ((JSONObject)result).toString(2);
            }
        }
        catch (JSONException jSONException) {}
        return result.toString();
    }

    public static void writeJSONResponse(HttpServletRequest req, HttpServletResponse resp, Object result) throws IOException {
        OrionServlet.writeJSONResponse(req, resp, result, true);
    }

    public static void writeJSONResponse(HttpServletRequest req, HttpServletResponse resp, Object result, boolean removeHostPort) throws IOException {
        Assert.isLegal((result instanceof JSONObject || result instanceof JSONArray ? 1 : 0) != 0);
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Cache-Control", "no-store");
        if (result instanceof JSONObject) {
            OrionServlet.decorateResponse(req, (JSONObject)result, removeHostPort);
        }
        resp.setContentType("application/json; charset=UTF-8");
        String response = OrionServlet.prettyPrint(result);
        resp.getWriter().print(response);
        LoggerFactory.getLogger(OrionServlet.class).debug(response);
    }

    private static void removeOwnProtocolHostPort(JSONObject json, String scheme, String hostname, int port) {
        String[] names = JSONObject.getNames((JSONObject)json);
        if (names == null) {
            return;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Object o = json.opt(name);
            if (o instanceof URI) {
                try {
                    json.put(name, (Object)OrionServlet.simplified((URI)o, scheme, hostname, port));
                }
                catch (JSONException jSONException) {}
            } else if (o instanceof String) {
                String string = (String)o;
                if (string.startsWith(scheme)) {
                    try {
                        json.put(name, (Object)OrionServlet.simplified(new URI(string), scheme, hostname, port));
                    }
                    catch (JSONException jSONException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            } else {
                OrionServlet.removeProtocolHostPort(o, scheme, hostname, port);
            }
            ++n2;
        }
    }

    private static void removeProtocolHostPort(Object o, String scheme, String hostname, int port) {
        if (o instanceof JSONObject) {
            OrionServlet.removeOwnProtocolHostPort((JSONObject)o, scheme, hostname, port);
        } else if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            int i = 0;
            while (i < a.length()) {
                Object v = a.opt(i);
                if (v instanceof URI) {
                    try {
                        a.put(i, (Object)OrionServlet.simplified((URI)v, scheme, hostname, port));
                    }
                    catch (JSONException jSONException) {}
                } else if (v instanceof String) {
                    String string = (String)v;
                    if (string.startsWith(scheme)) {
                        try {
                            a.put(i, (Object)OrionServlet.simplified(new URI(string), scheme, hostname, port));
                        }
                        catch (JSONException jSONException) {
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                } else {
                    OrionServlet.removeProtocolHostPort(v, scheme, hostname, port);
                }
                ++i;
            }
        }
    }

    private static URI simplified(URI uri, String scheme, String hostname, int port) {
        URI simpleURI = uri;
        int uriPort = uri.getPort();
        if (uriPort == -1) {
            uriPort = 80;
        }
        if (scheme.equals(uri.getScheme()) && hostname.equals(uri.getHost()) && port == uriPort) {
            try {
                simpleURI = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                simpleURI = uri;
            }
        }
        return simpleURI;
    }

    public static void decorateResponse(HttpServletRequest req, JSONObject result, boolean removeHostPort) {
        OrionServlet.decorateResponse(req, result);
        if (removeHostPort && "XMLHttpRequest".equals(req.getHeader("X-Requested-With"))) {
            OrionServlet.removeOwnProtocolHostPort(result, req.getScheme(), req.getServerName(), req.getServerPort());
        }
    }

    public static void decorateResponse(HttpServletRequest req, JSONObject result) {
        Collection<IWebResourceDecorator> decorators = Activator.getDefault().getWebResourceDecorators();
        URI requestURI = ServletResourceHandler.getURI(req);
        for (IWebResourceDecorator decorator : decorators) {
            decorator.addAtributesFor(req, requestURI, result);
        }
    }

    public static JSONObject readJSONRequest(HttpServletRequest request) throws IOException, JSONException {
        StringWriter writer = new StringWriter();
        IOUtilities.pipe((Reader)request.getReader(), (Writer)writer, (boolean)false, (boolean)false);
        String resultString = writer.toString();
        if (resultString.length() == 0) {
            return new JSONObject();
        }
        return new JSONObject(resultString);
    }

    protected String createQuery(HttpServletRequest req, String query) {
        StringBuffer requestURL = req.getRequestURL();
        int indexOfURI = requestURL.indexOf(req.getRequestURI().toString());
        return requestURL.replace(indexOfURI, requestURL.length(), query).toString();
    }

    protected ServletResourceHandler<IStatus> getStatusHandler() {
        return statusHandler;
    }

    protected void handleException(HttpServletResponse response, IStatus status) throws ServletException {
        statusHandler.handleRequest(null, response, status);
    }

    protected void handleException(HttpServletResponse response, IStatus status, int httpCode) throws ServletException {
        this.handleException(response, (IStatus)new ServerStatus(status, httpCode));
    }

    protected void handleException(HttpServletResponse resp, String msg, Exception e) throws ServletException {
        this.handleException(resp, msg, e, 500);
    }

    protected void handleException(HttpServletResponse resp, String msg, Exception e, int httpCode) throws ServletException {
        this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e), httpCode);
    }

    protected void printHeaders(HttpServletRequest req, StringBuffer out) {
        for (String header : Collections.list(req.getHeaderNames())) {
            out.append(String.valueOf(header) + ": " + req.getHeader(header) + "\n");
        }
    }

    protected void traceRequest(HttpServletRequest req) {
        StringBuffer result = new StringBuffer(req.getMethod());
        result.append(' ');
        result.append(req.getRequestURI());
        String query = req.getQueryString();
        if (query != null) {
            result.append('?').append(query);
        }
        LoggerFactory.getLogger(OrionServlet.class).debug(result.toString());
    }

    public static URI getURI(HttpServletRequest request) {
        StringBuffer result = request.getRequestURL();
        try {
            return new URI(result.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

