/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.SolrFilter;
import org.apache.solr.search.function.ValueSource;

public class ValueSourceRangeFilter
extends SolrFilter {
    private final ValueSource valueSource;
    private final String lowerVal;
    private final String upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public ValueSourceRangeFilter(ValueSource valueSource, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        this.valueSource = valueSource;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = lowerVal != null && includeLower;
        this.includeUpper = upperVal != null && includeUpper;
    }

    public DocIdSet getDocIdSet(final Map context, final IndexReader reader) throws IOException {
        return new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                return ValueSourceRangeFilter.this.valueSource.getValues(context, reader).getRangeScorer(reader, ValueSourceRangeFilter.this.lowerVal, ValueSourceRangeFilter.this.upperVal, ValueSourceRangeFilter.this.includeLower, ValueSourceRangeFilter.this.includeUpper);
            }
        };
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.valueSource.createWeight(context, searcher);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("frange(");
        sb.append(this.valueSource);
        sb.append("):");
        sb.append(this.includeLower ? (char)'[' : '{');
        sb.append(this.lowerVal == null ? "*" : this.lowerVal);
        sb.append(" TO ");
        sb.append(this.upperVal == null ? "*" : this.upperVal);
        sb.append(this.includeUpper ? (char)']' : '}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueSourceRangeFilter)) {
            return false;
        }
        ValueSourceRangeFilter other = (ValueSourceRangeFilter)((Object)o);
        if (!this.valueSource.equals(other.valueSource) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        return !(this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null);
    }

    public int hashCode() {
        int h = this.valueSource.hashCode();
        h += this.lowerVal != null ? this.lowerVal.hashCode() : 1461933019;
        h = h << 16 | h >>> 16;
        h += this.upperVal != null ? this.upperVal.hashCode() : -512759321;
        return h += (this.includeLower ? -626755208 : 0) + (this.includeUpper ? -1637659817 : 0);
    }
}

