/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.util.Map;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseResult {
    static final RebaseResult OK_RESULT = new RebaseResult(Status.OK);
    static final RebaseResult ABORTED_RESULT = new RebaseResult(Status.ABORTED);
    static final RebaseResult UP_TO_DATE_RESULT = new RebaseResult(Status.UP_TO_DATE);
    static final RebaseResult FAST_FORWARD_RESULT = new RebaseResult(Status.FAST_FORWARD);
    private final Status status;
    private final RevCommit currentCommit;
    private Map<String, ResolveMerger.MergeFailureReason> failingPaths;

    private RebaseResult(Status status) {
        this.status = status;
        this.currentCommit = null;
    }

    RebaseResult(RevCommit commit) {
        this.status = Status.STOPPED;
        this.currentCommit = commit;
    }

    RebaseResult(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        this.status = Status.FAILED;
        this.currentCommit = null;
        this.failingPaths = failingPaths;
    }

    public Status getStatus() {
        return this.status;
    }

    public RevCommit getCurrentCommit() {
        return this.currentCommit;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        ABORTED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        STOPPED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        FAILED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        UP_TO_DATE{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAST_FORWARD{

            public boolean isSuccessful() {
                return true;
            }
        };


        public abstract boolean isSuccessful();
    }
}

