/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.useradmin.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
implements org.osgi.service.useradmin.User {
    private static final String PASSWORD = "password";
    private static final String NAME = "name";
    public static final String LOGIN = "login";
    public static final String UID = "uid";
    public static final String EMAIL = "email";
    public static final String EMAIL_CONFIRMATION = "email_confirmation";
    private Set<Role> roles = new HashSet<Role>();
    private Properties userCredentials = new Properties();
    private Properties properties = new Properties();

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public void removeRole(Role role) {
        this.roles.remove(role);
    }

    public User() {
    }

    public User(String uid, String login, String name, String password) {
        this.userCredentials.setProperty(UID, uid);
        this.setLogin(login);
        if (name != null) {
            this.setName(name);
        }
        if (password != null) {
            this.setPassword(password);
        }
    }

    public User(String login, String name, String password) {
        this.setLogin(login);
        if (name != null) {
            this.setName(name);
        }
        if (password != null) {
            this.setPassword(password);
        }
    }

    public User(String login) {
        this.setLogin(login);
    }

    public String getUid() {
        return this.userCredentials.getProperty(UID);
    }

    public String getLogin() {
        return this.userCredentials.getProperty(LOGIN);
    }

    public void setLogin(String login) {
        this.userCredentials.setProperty(LOGIN, login);
    }

    public String getName() {
        return this.userCredentials.getProperty(NAME);
    }

    public void setName(String name) {
        this.userCredentials.setProperty(NAME, name);
    }

    public String getPassword() {
        return this.userCredentials.getProperty(PASSWORD);
    }

    public void setPassword(String password) {
        this.userCredentials.setProperty(PASSWORD, password);
    }

    public int getType() {
        return 1;
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public Dictionary getCredentials() {
        return this.userCredentials;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public boolean hasCredential(String key, Object value) {
        return this.userCredentials.containsKey(key) ? this.userCredentials.get(key).equals(value) : false;
    }

    public String getLocation() {
        return "/users/" + this.getUid();
    }

    public static String getUniqueEmailConfirmationId() {
        return String.valueOf(System.currentTimeMillis()) + "-" + Math.random();
    }

    public void setEmail(String email) {
        this.userCredentials.setProperty(EMAIL, email);
    }

    public String getEmail() {
        return this.userCredentials.getProperty(EMAIL);
    }

    public String getConfirmationId() {
        return this.userCredentials.getProperty(EMAIL_CONFIRMATION);
    }

    public void setConfirmationId(String confirmationId) {
        this.userCredentials.setProperty(EMAIL_CONFIRMATION, confirmationId);
    }

    public void confirmEmail() {
        this.userCredentials.remove(EMAIL_CONFIRMATION);
    }

    public void setConfirmationId() {
        this.userCredentials.setProperty(EMAIL_CONFIRMATION, User.getUniqueEmailConfirmationId());
    }

    public boolean isEmailConfirmed() {
        return this.userCredentials.getProperty(EMAIL_CONFIRMATION) == null;
    }
}

