/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class GitObject {
    protected URI cloneLocation;
    protected Repository db;
    private StoredConfig cfg;

    GitObject(URI cloneLocation, Repository db) {
        this.cloneLocation = cloneLocation;
        this.db = db;
    }

    StoredConfig getConfig() {
        if (this.cfg == null) {
            this.cfg = this.db.getConfig();
        }
        return this.cfg;
    }

    protected abstract String getType();

    protected abstract URI getLocation() throws URISyntaxException;

    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = new JSONObject();
        result.put("Type", (Object)this.getType());
        result.put("Location", (Object)this.getLocation());
        result.put("CloneLocation", (Object)this.cloneLocation);
        return result;
    }
}

