/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.patch;

import java.io.IOException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.orion.server.git.patch.HunkControlChar;

public class ApplyError {
    private FileHeader fileHeader;
    private DiffEntry.ChangeType changeType;
    private HunkControlChar hunkContorlChar;
    private HunkHeader hunkHeader;
    private IOException ioException;

    public ApplyError(FileHeader fh, DiffEntry.ChangeType t, HunkControlChar hcc) {
        this.fileHeader = fh;
        this.changeType = t;
        this.hunkContorlChar = hcc;
    }

    public ApplyError(FileHeader fh, DiffEntry.ChangeType t) {
        this(fh, t, null);
    }

    public ApplyError(HunkHeader hh, HunkControlChar hcc) {
        this(hh.getFileHeader(), DiffEntry.ChangeType.MODIFY, hcc);
        this.hunkHeader = hh;
    }

    public ApplyError(IOException e) {
        this.ioException = e;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public HunkHeader getHunkHeader() {
        return this.hunkHeader;
    }

    public DiffEntry.ChangeType getChangeType() {
        return this.changeType;
    }

    public HunkControlChar getHunkControlChar() {
        return this.hunkContorlChar;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.ioException != null) {
            r.append(this.ioException.getMessage());
        } else {
            r.append(this.getChangeType().name());
            if (this.getHunkControlChar() != null) {
                r.append(",");
                r.append(this.getHunkControlChar().name());
            }
            r.append(": at hunk ");
            r.append(this.toString(this.getHunkHeader()));
            r.append("  in ");
            r.append(this.getFileHeader());
        }
        return r.toString();
    }

    private String toString(HunkHeader hh) {
        StringBuilder buf = new StringBuilder();
        buf.append("HunkHeader[");
        buf.append(String.valueOf(hh.getOldImage().getStartLine()) + "," + hh.getOldImage().getLineCount());
        buf.append("->");
        buf.append(String.valueOf(hh.getNewStartLine()) + "," + hh.getNewLineCount());
        buf.append("]");
        return buf.toString();
    }
}

