/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.tasks;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.server.core.tasks.ITaskCanceler;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class TaskJob
extends Job
implements ITaskCanceler {
    private String userRunningTask;
    private boolean isIdempotent;
    private boolean canCancel;
    private String message;
    private String finalMessage = "Done";
    private URI finalLocation = null;
    private TaskInfo task;
    private ITaskService taskService;
    private ServiceReference<ITaskService> taskServiceRef;
    private IStatus realResult;

    public TaskJob(String taskName, String userRunningTask, String initialMessage, boolean isIdempotent, boolean canCancel) {
        super(taskName);
        this.userRunningTask = userRunningTask;
        this.isIdempotent = isIdempotent;
        this.canCancel = canCancel;
        this.message = initialMessage;
    }

    public TaskJob(String userRunningTask, String taskName, String initialMessage) {
        this(userRunningTask, taskName, initialMessage, false, false);
    }

    public TaskJob(String userRunningTask, String taskName) {
        this(userRunningTask, taskName, "", false, false);
    }

    protected void setFinalMessage(String message) {
        this.finalMessage = message;
    }

    public URI getFinalLocation() {
        return this.finalLocation;
    }

    protected void setFinalLocation(URI location) {
        this.finalLocation = location;
    }

    public JSONObject getFinalResult() throws JSONException {
        JSONObject finalResult = new JSONObject();
        if (this.finalLocation != null) {
            finalResult.put("Location", (Object)this.finalLocation);
        }
        finalResult.put("Message", (Object)(this.finalMessage == null ? this.message : this.finalMessage));
        return finalResult;
    }

    public IStatus getRealResult() {
        return this.realResult;
    }

    ITaskService getTaskService() {
        if (this.taskService == null) {
            BundleContext context = Activator.getDefault().getContext();
            if (this.taskServiceRef == null) {
                this.taskServiceRef = context.getServiceReference(ITaskService.class);
                if (this.taskServiceRef == null) {
                    throw new IllegalStateException("Task service not available");
                }
            }
            this.taskService = (ITaskService)context.getService(this.taskServiceRef);
            if (this.taskService == null) {
                throw new IllegalStateException("Task service not available");
            }
        }
        return this.taskService;
    }

    private synchronized void cleanUp() {
        if (this.task != null && this.task.isRunning()) {
            this.setTaskResult((IStatus)(this.getRealResult() == null ? new Status(4, "org.eclipse.orion.server.core", "Task finished with unknown status.") : this.getRealResult()));
        }
        this.taskService = null;
        if (this.taskServiceRef != null) {
            Activator.getDefault().getContext().ungetService(this.taskServiceRef);
            this.taskServiceRef = null;
        }
    }

    protected void setMessage(String message) {
        this.message = message;
        if (this.task != null) {
            this.task.setMessage(message);
            this.getTaskService().updateTask(this.task);
        }
    }

    public synchronized TaskInfo startTask() {
        this.task = this.canCancel ? this.getTaskService().createTask(this.getName(), this.userRunningTask, this, this.isIdempotent) : this.getTaskService().createTask(this.getName(), this.userRunningTask, this.isIdempotent);
        if (this.message != null && this.message.length() > 0) {
            this.task.setMessage(this.message);
            this.getTaskService().updateTask(this.task);
        }
        if (this.getRealResult() != null) {
            this.setTaskResult(this.getRealResult());
        }
        return this.task;
    }

    protected abstract IStatus performJob();

    private synchronized void setTaskResult(IStatus result) {
        if (result.isOK()) {
            if (this.finalLocation != null) {
                this.task.setResultLocation(this.finalLocation);
            }
            this.task.done(result);
            this.task.setMessage(this.finalMessage);
        } else {
            this.task.done(result);
        }
        this.getTaskService().updateTask(this.task);
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        try {
            this.realResult = this.performJob();
            if (this.task == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.setTaskResult(this.realResult);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.cleanUp();
        }
    }

    public void cancelTask() {
        this.cancel();
    }

    protected void canceling() {
        super.canceling();
        if (this.task != null && this.task.isRunning()) {
            this.task.done((IStatus)new Status(8, "org.eclipse.orion.server.core", "Task was canceled."));
            this.getTaskService().updateTask(this.task);
        }
        this.cleanUp();
    }
}

