/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.Activator;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.form.httpcontext.BundleEntryHttpContext;
import org.eclipse.orion.server.authentication.form.servlets.LoginServlet;
import org.eclipse.orion.server.authentication.form.servlets.LogoutServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class FormAuthenticationService
implements IAuthenticationService {
    public static final String CSS_LINK_PROPERTY = "STYLES";
    private Properties defaultAuthenticationProperties;
    private HttpService httpService;
    private boolean registered = false;

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp, properties);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String username = FormAuthHelper.getAuthenticatedUser((HttpServletRequest)req);
        if (username != null) {
            return username;
        }
        return null;
    }

    public String getAuthType() {
        return "FORM";
    }

    public void configure(Properties properties) {
        this.defaultAuthenticationProperties = properties;
        try {
            this.httpService.registerResources("/authenticationPlugin.html", "/web/authenticationPlugin.html", (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
        }
        catch (Exception exception) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.authentication.form", "Reconfiguring FormAutneticationService"));
        }
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            resp.sendRedirect(String.valueOf(req.getContextPath()) + "/loginstatic/LoginWindow.html?redirect=" + req.getRequestURL());
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            JSONObject result = new JSONObject();
            try {
                result.put("SignInLocation", (Object)"/loginstatic/LoginWindow.html");
                result.put("label", (Object)"Orion workspace server");
                result.put("SignInKey", (Object)"FormSignInKey");
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "An error occured during authenitcation", (Throwable)e));
            }
            resp.getWriter().print(result.toString());
        }
    }

    public void setHttpService(HttpService hs) {
        this.httpService = hs;
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getBundleContext().getBundle());
        try {
            this.httpService.registerServlet("/login", (Servlet)new LoginServlet(), null, (HttpContext)httpContext);
            this.httpService.registerServlet("/logout", (Servlet)new LogoutServlet(), null, (HttpContext)httpContext);
            this.httpService.registerResources("/loginstatic", "/web", (HttpContext)httpContext);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService hs) {
        this.httpService.unregister("/login");
        this.httpService.unregister("/logout");
        this.httpService.unregister("/loginstatic");
        this.httpService = null;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean getRegistered() {
        return this.registered;
    }
}

